package org.mule.datasense.api.metadataprovider;

import static org.mule.runtime.config.spring.api.XmlConfigurationDocumentLoader.noValidationDocumentLoader;

import org.mule.runtime.config.spring.api.dsl.model.ComponentBuildingDefinitionRegistry;
import org.mule.runtime.config.spring.api.dsl.processor.ArtifactConfig;
import org.mule.runtime.config.spring.api.dsl.processor.ConfigFile;
import org.mule.runtime.config.spring.api.dsl.processor.ConfigLine;
import org.mule.runtime.config.spring.api.dsl.processor.xml.XmlApplicationParser;
import org.mule.runtime.core.api.registry.ServiceRegistry;
import org.mule.runtime.core.api.registry.SpiServiceRegistry;

import java.io.InputStream;
import java.util.Collections;
import java.util.Optional;

import org.w3c.dom.Document;

public class BaseApplicationModelFactory {

  protected Optional<ConfigLine> loadConfigLines(InputStream inputStream) {
    ServiceRegistry serviceRegistry = new SpiServiceRegistry();
    XmlApplicationParser xmlApplicationParser = new XmlApplicationParser(serviceRegistry, Collections.emptyList());
    Document document = noValidationDocumentLoader().loadDocument("config", inputStream); // // TODO: 11/23/16
    return xmlApplicationParser.parse(document.getDocumentElement());
  }

  protected org.mule.runtime.config.spring.api.dsl.model.ApplicationModel loadApplicationModel(ConfigLine configLine)
      throws Exception {
    ArtifactConfig artifactConfig = new ArtifactConfig.Builder()
        .addConfigFile(new ConfigFile("", Collections.singletonList(configLine))).build();
    org.mule.runtime.config.spring.api.dsl.model.ApplicationModel applicationModel =
        new org.mule.runtime.config.spring.api.dsl.model.ApplicationModel(artifactConfig, null,
                                                                          Collections.emptySet(), Collections.emptyMap(),
                                                                          Optional.empty(),
                                                                          Optional.of(new ComponentBuildingDefinitionRegistry()),
                                                                          false, s -> {
                                                                            throw new UnsupportedOperationException();
                                                                          });

    return applicationModel;
  }
}
