package org.mule.datasense.api.metadataprovider;

import java.net.URI;
import java.util.Optional;
import java.util.function.Function;

public class DefaultApplicationModel implements ApplicationModel {

  private final String name;
  private org.mule.runtime.config.spring.api.dsl.model.ApplicationModel applicationModel;
  private final String typesData;
  private final Function<String, Optional<URI>> resourceResolver;

  public DefaultApplicationModel(String name,
                                 org.mule.runtime.config.spring.api.dsl.model.ApplicationModel applicationModel) {
    this(name, applicationModel, null);
  }

  public DefaultApplicationModel(String name,
                                 org.mule.runtime.config.spring.api.dsl.model.ApplicationModel applicationModel,
                                 String typesData) {
    this(name, applicationModel, typesData, null);
  }

  public DefaultApplicationModel(String name,
                                 org.mule.runtime.config.spring.api.dsl.model.ApplicationModel applicationModel, String typesData,
                                 Function<String, Optional<URI>> resourceResolver) {
    this.name = name;
    this.applicationModel = applicationModel;
    this.typesData = typesData;
    this.resourceResolver = resourceResolver;
  }

  public String getName() {
    return name;
  }

  public org.mule.runtime.config.spring.api.dsl.model.ApplicationModel getMuleApplicationModel() {
    return applicationModel;
  }

  @Override
  public org.mule.runtime.config.spring.api.dsl.model.ComponentModel findRootComponentModel() {
    return getMuleApplicationModel().getRootComponentModel();
  }

  @Override
  public Optional<org.mule.runtime.config.spring.api.dsl.model.ComponentModel> findNamedComponent(String name) {
    return getMuleApplicationModel().findTopLevelNamedComponent(name);
  }

  @Override
  public Optional<String> findTypesData() {
    return Optional.ofNullable(typesData);
  }

  public Optional<Function<String, Optional<URI>>> getResourceResolver() {
    return Optional.ofNullable(resourceResolver);
  }

  @Override
  public Optional<URI> findResource(String resource) {
    return getResourceResolver().map(resourceResolver -> resourceResolver.apply(resource)).orElse(Optional.empty());
  }
}
