package org.mule.datasense.impl.model.ast;

import org.mule.datasense.impl.util.AnnotationSupport;import org.mule.runtime.api.component.ComponentIdentifier;;

import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;

abstract class BaseAstNode implements AstNode {

  private final ComponentIdentifier componentIdentifier;
  private final AnnotationSupport<AstNodeAnnotation> annotationSupport;
  private String name;
  private AstNodeLocation astNodeLocation;

  public BaseAstNode(ComponentIdentifier componentIdentifier) {
    this.componentIdentifier = componentIdentifier;
    this.annotationSupport = new AnnotationSupport<>();

  }

  @Override
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  @Override
  public AstNodeLocation getAstNodeLocation() {
    return astNodeLocation;
  }

  public void setAstNodeLocation(AstNodeLocation astNodeLocation) {
    this.astNodeLocation = astNodeLocation;
  }

  @Override
  public ComponentIdentifier getIdentifier() {
    return componentIdentifier;
  }

  public Set<AstNodeAnnotation> getAnnotations() {
    return annotationSupport.getAnnotations();
  }

  public <T extends AstNodeAnnotation> Optional<T> getAnnotation(Class<T> annotation) {
    return annotationSupport.getAnnotation(annotation);
  }

  public <T extends AstNodeAnnotation> void annotate(T annotation) {
    annotationSupport.annotate(annotation);
  }

  public <T extends AstNodeAnnotation> boolean isAnnotatedWith(Class<T> annotationClass) {
    return annotationSupport.isAnnotatedWith(annotationClass);
  }

  public <T extends AstNodeAnnotation> T getOrCreateAnnotation(Class<T> annotationClass,
                                                               Supplier<T> supplier) {
    return annotationSupport.getOrCreateAnnotation(annotationClass, supplier);
  }

  public <T extends AstNodeAnnotation> Optional<T> deannotate(Class<T> annotation) {
    return annotationSupport.deannotate(annotation);
  }

}
