package org.mule.datasense.impl.model.ast;

import org.mule.datasense.impl.phases.builder.ComponentModelType;
import org.mule.metadata.api.model.FunctionType;
import org.mule.runtime.config.spring.api.dsl.model.ComponentModel;

import com.google.common.base.Preconditions;
import org.mule.runtime.api.component.ComponentIdentifier;import org.mule.runtime.dsl.api.component.config.DefaultComponentLocation;;

import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;

public class MessageProcessorNode extends BaseAstNode {

  private final ComponentModelType componentModelType;
  private final ComponentIdentifier componentIdentifier;
  private final ComponentModel componentModel;
  private final List<MessageProcessorNode> messageProcessorNodeList;
  private AstNode parentAstNode;
  private boolean rootMessageProcessorNode;
  private boolean synthetic;

  public MessageProcessorNode(ComponentIdentifier componentIdentifier,
                              ComponentModel componentModel, List<MessageProcessorNode> messageProcessorNodeList,
                              FunctionType declaredFunctionType, ComponentModelType componentModelType) {
    this(componentIdentifier, componentModel, messageProcessorNodeList, declaredFunctionType, componentModelType, false);
  }

  public MessageProcessorNode(ComponentIdentifier componentIdentifier,
                              ComponentModel componentModel, List<MessageProcessorNode> messageProcessorNodeList,
                              FunctionType declaredFunctionType, ComponentModelType componentModelType, boolean synthetic) {
    super(componentIdentifier);
    Preconditions.checkNotNull(componentIdentifier);
    Preconditions.checkNotNull(messageProcessorNodeList);

    setName(componentIdentifier.toString());

    this.synthetic = synthetic;
    this.componentIdentifier = componentIdentifier;
    this.componentModel = componentModel;
    this.messageProcessorNodeList = messageProcessorNodeList;
    this.componentModelType = componentModelType;
    if (componentModel != null) {
      final DefaultComponentLocation componentLocation = componentModel.getComponentLocation();
      if (componentLocation != null) {
        setAstNodeLocation(new AstNodeLocation(componentLocation));
      }
    }
  }

  public MessageProcessorNode(ComponentIdentifier componentIdentifier,
                              ComponentModel componentModel, List<MessageProcessorNode> messageProcessorNodeList,
                              boolean synthetic) {
    this(componentIdentifier, componentModel, messageProcessorNodeList, null, null, synthetic);
  }

  public MessageProcessorNode(ComponentIdentifier componentIdentifier,
                              ComponentModel componentModel, List<MessageProcessorNode> messageProcessorNodeList) {
    this(componentIdentifier, componentModel, messageProcessorNodeList, null, null, false);
  }

  public void setParentAstNode(AstNode parentAstNode) {
    this.parentAstNode = parentAstNode;
  }

  public AstNode getParentAstNode() {
    return parentAstNode;
  }

  public boolean isRootMessageProcessorNode() {
    return rootMessageProcessorNode;
  }

  public void setRootMessageProcessorNode(boolean rootMessageProcessorNode) {
    this.rootMessageProcessorNode = rootMessageProcessorNode;
  }

  public ComponentIdentifier getComponentIdentifier() {
    return componentIdentifier;
  }

  public Stream<MessageProcessorNode> getMessageProcessorNodes() {
    return messageProcessorNodeList.stream();
  }

  @Override
  public <T> Object accept(AstNodeVisitor<T> astNodeVisitor, T context) {
    return astNodeVisitor.visit(this, context);
  }

  public ComponentModel getComponentModel() {
    return componentModel;
  }

  public Optional<ComponentModelType> getComponentModelType() {
    return Optional.ofNullable(componentModelType);
  }

  public boolean isSynthetic() {
    return synthetic;
  }
}
