package org.mule.datasense.impl.model.event;

import org.mule.datasense.impl.phases.typing.resolver.ResolveTypeContext;
import org.mule.metadata.message.MuleEventMetadataType;
import org.mule.metadata.message.MuleEventMetadataTypeBuilder;

public class DefMessage implements DefElem {

  private final MessageExpr value;

  public DefMessage(MessageExpr value) {
    this.value = value;
  }

  @Override
  public void resolveType(MuleEventMetadataTypeBuilder muleEventMetadataTypeBuilder,
                          MuleEventMetadataType muleEventMetadataType,
                          ResolveTypeContext resolveTypeContext) {
    muleEventMetadataTypeBuilder.message(value.resolveType(muleEventMetadataType, resolveTypeContext));
  }

  @Override
  public void resolveInputType(MuleEventMetadataTypeBuilder muleEventMetadataTypeBuilder,
                               MuleEventMetadataType muleEventMetadataType, ResolveTypeContext resolveTypeContext) {
    value.resolveInputType(muleEventMetadataTypeBuilder, muleEventMetadataType.getMessageType(), resolveTypeContext);
  }
}
