package org.mule.datasense.impl.model.event;

import java.util.function.Consumer;

public class DefMessageBuilder implements DefElemBuilder {

  private MessageExprBuilder value;

  public DefMessageBuilder() {
    value = new MessageExprBuilder();
  }

  public DefMessageBuilder value(Consumer<MessageExprBuilder> messageExprBuilderConsumer) {
    if (value == null) {
      value = new MessageExprBuilder();
    }
    messageExprBuilderConsumer.accept(value);
    return this;
  }

  @Override
  public DefElem build() {
    return new DefMessage((MessageExpr) value.build());
  }
}
