package org.mule.datasense.impl.model.event;

import org.mule.datasense.impl.model.types.TypesHelper;
import org.mule.datasense.impl.phases.typing.resolver.ResolveTypeContext;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.message.MuleEventMetadataType;
import org.mule.metadata.message.MuleEventMetadataTypeBuilder;

public class DefVariable implements DefElem {

  private final String name;
  private final DefElemValueExpr value;

  public DefVariable(String name, DefElemValueExpr value) {
    this.name = name;
    this.value = value;
  }

  @Override
  public void resolveType(MuleEventMetadataTypeBuilder muleEventMetadataTypeBuilder,
                          MuleEventMetadataType muleEventMetadataType,
                          ResolveTypeContext resolveTypeContext) {
    muleEventMetadataTypeBuilder.addVariable(name, value.resolveType(muleEventMetadataType, resolveTypeContext));
  }

  @Override
  public void resolveInputType(MuleEventMetadataTypeBuilder muleEventMetadataTypeBuilder,
                               MuleEventMetadataType muleEventMetadataType, ResolveTypeContext resolveTypeContext) {
    final MetadataType metadataType =
        muleEventMetadataType.getVariables().getFieldByName(name).map(objectFieldType -> objectFieldType.getValue())
            .orElse(TypesHelper.getTypeBuilder().anyType().build());
    value.resolveInputType(muleEventMetadataTypeBuilder, metadataType, resolveTypeContext);
  }
}
