package org.mule.datasense.impl.model.event;

import org.mule.datasense.impl.phases.typing.resolver.ResolveTypeContext;
import org.mule.metadata.message.MuleEventMetadataType;
import org.mule.metadata.message.MuleEventMetadataTypeBuilder;

import java.util.List;

public class MuleEventExpr {

  private final List<DefElem> definitions;

  public MuleEventExpr(List<DefElem> definitions) {
    this.definitions = definitions;
  }

  public MuleEventMetadataType resolveType(MuleEventMetadataType muleEventMetadataType,
                                           ResolveTypeContext resolveTypeContext) {
    MuleEventMetadataTypeBuilder muleEventMetadataTypeBuilder = new MuleEventMetadataTypeBuilder();
    definitions.forEach(defElem -> defElem.resolveType(muleEventMetadataTypeBuilder, muleEventMetadataType, resolveTypeContext));
    return muleEventMetadataTypeBuilder.build();
  }

  public MuleEventMetadataType resolveInputType(MuleEventMetadataType muleEventMetadataType,
                                                ResolveTypeContext resolveTypeContext) {
    MuleEventMetadataTypeBuilder muleEventMetadataTypeBuilder = new MuleEventMetadataTypeBuilder();
    definitions
        .forEach(defElem -> defElem.resolveInputType(muleEventMetadataTypeBuilder, muleEventMetadataType, resolveTypeContext));
    return muleEventMetadataTypeBuilder.build();
  }
}
