package org.mule.datasense.impl.model.event;

import com.google.common.base.Preconditions;
import org.mule.datasense.impl.phases.typing.resolver.ResolveTypeContext;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.message.MuleEventMetadataType;
import org.mule.metadata.message.MuleEventMetadataTypeBuilder;
import org.mule.metadata.message.el.ExpressionLanguageMetadataTypeResolver;

public class SimpleExpr implements Expr {

  private final String expression;

  public SimpleExpr(String expression) {
    Preconditions.checkNotNull(expression);
    this.expression = expression;
  }

  @Override
  public MetadataType resolveType(MuleEventMetadataType muleEventMetadataType,
                                  ResolveTypeContext resolveTypeContext) {
    return resolveTypeContext.getExpressionLanguageMetadataTypeResolver().getOutputType(muleEventMetadataType, expression,
                                                                                        resolveTypeContext.getMessageCallback());
  }

  @Override
  public void resolveInputType(MetadataType metadataType, MuleEventMetadataTypeBuilder muleEventMetadataTypeBuilder,
                               ResolveTypeContext resolveTypeContext) {
    resolveTypeContext.getExpressionLanguageMetadataTypeResolver()
        .getInputType(expression, metadataType, muleEventMetadataTypeBuilder, resolveTypeContext.getMessageCallback());
  }

}
