package org.mule.datasense.impl.phases.annotators;

import org.mule.datasense.impl.model.annotations.ComponentLocationAnnotation;
import org.mule.datasense.impl.model.annotations.MuleApplicationAnnotation;
import org.mule.datasense.impl.model.annotations.MuleFlowAnnotation;
import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.model.ast.MuleApplicationNode;
import org.mule.datasense.impl.model.ast.MuleFlowNode;
import org.mule.datasense.impl.phases.typing.AnnotatingMuleAstVisitorContext;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.config.spring.api.dsl.model.ComponentModel;
import org.mule.runtime.dsl.api.component.config.DefaultComponentLocation;

public class InfoAnnotator extends BaseAnnotator {

  @Override
  public void annotate(MessageProcessorNode messageProcessorNode,
                       AnnotatingMuleAstVisitorContext annotatingMuleAstVisitorContext) {
    annotatingMuleAstVisitorContext.getAnnotation(MuleApplicationAnnotation.class).ifPresent(muleApplicationAnnotation -> {
      MuleApplicationNode muleApplicationNode = muleApplicationAnnotation.getMuleApplicationNode();
      annotatingMuleAstVisitorContext.getAnnotation(MuleFlowAnnotation.class).ifPresent(muleFlowAnnotation -> {
        MuleFlowNode muleFlowNode = muleFlowAnnotation.getMuleFlowNode();
        ComponentModel componentModel = messageProcessorNode.getComponentModel();
        final DefaultComponentLocation componentLocation = componentModel.getComponentLocation();
        messageProcessorNode.annotate(new ComponentLocationAnnotation(componentLocation));
        if (!messageProcessorNode.isSynthetic()) {
          muleFlowNode.register(componentLocation, messageProcessorNode);
          muleApplicationNode.register(componentLocation, messageProcessorNode);
        }
      });
    });
  }

}
