package org.mule.datasense.impl.phases.annotators;

import org.mule.datasense.impl.DefaultDataSense;
import org.mule.datasense.impl.model.annotations.HasSourceAnnotation;
import org.mule.datasense.impl.model.annotations.MuleFlowAnnotation;
import org.mule.datasense.impl.model.annotations.VoidOperationAnnotation;
import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.model.operation.OperationCall;
import org.mule.datasense.impl.model.operation.OperationCallBuilder;
import org.mule.datasense.impl.phases.typing.AnnotatingMuleAstVisitorContext;
import org.mule.datasense.impl.model.annotations.MessageSourceRegionContextAnnotation;
import org.mule.datasense.impl.model.annotations.OperationCallAnnotation;
import org.mule.datasense.impl.model.annotations.OperationCallBuilderAnnotation;
import org.mule.datasense.impl.model.annotations.TypeResolverAnnotation;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.VoidType;
import org.mule.metadata.message.MessageMetadataType;

public class OperationCallAnnotator extends BaseAnnotator {

  private final SourceAnnotator sourceAnnotator;
  private final OperationAnnotator operationAnnotator;

  public OperationCallAnnotator() {
    sourceAnnotator = new SourceAnnotator();
    operationAnnotator = new OperationAnnotator();
  }

  @Override
  public void annotate(MessageProcessorNode messageProcessorNode,
                       AnnotatingMuleAstVisitorContext annotatingMuleAstVisitorContext) {
    if (!messageProcessorNode.isRootMessageProcessorNode()) {
      if (!messageProcessorNode.getAnnotation(TypeResolverAnnotation.class).isPresent()) {
        messageProcessorNode.getComponentModelType().ifPresent(componentModelType -> {
          switch (componentModelType) {
            case MESSAGE_PROCESSOR_NODE:
              operationAnnotator.annotate(messageProcessorNode, annotatingMuleAstVisitorContext);
              break;
            case MESSAGE_SOURCE_NODE:
              sourceAnnotator.annotate(messageProcessorNode, annotatingMuleAstVisitorContext);
              break;
          }
        });

        messageProcessorNode.getAnnotation(OperationCallBuilderAnnotation.class).ifPresent(operationCallBuilderAnnotation -> {
          OperationCallBuilder operationCallBuilder = operationCallBuilderAnnotation.getOperationCallBuilder();
          OperationCall operationCall = operationCallBuilder.build();
          if (isVoidOperation(operationCall)) {
            messageProcessorNode.annotate(new VoidOperationAnnotation());
          }
          messageProcessorNode.annotate(new OperationCallAnnotation(operationCall));
          messageProcessorNode.annotate(new TypeResolverAnnotation(DefaultDataSense.COMPONENT_IDENTIFIER_OPERATION_CALL));
        });
      }
    }
  }

  private boolean isVoidOperation(OperationCall operationCall) {
    boolean result = false;
    final MetadataType returnType = operationCall.getReturnType();
    if (returnType instanceof MessageMetadataType) {
      MessageMetadataType messageMetadataType = (MessageMetadataType) returnType;
      result =
          (!messageMetadataType.getPayloadType().isPresent() || messageMetadataType.getPayloadType().get() instanceof VoidType)
              && (!messageMetadataType.getAttributesType().isPresent()
                  || messageMetadataType.getAttributesType().get() instanceof VoidType);
    }
    return result;
  }

}
