package org.mule.datasense.impl.phases.annotators;

import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.model.operation.OperationCallBuilder;
import org.mule.datasense.impl.model.types.TypesHelper;
import org.mule.datasense.impl.util.ExpressionLanguageUtils;
import org.mule.datasense.impl.util.extension.DslElementModelVisitor;
import org.mule.datasense.impl.util.extension.DslElementModelWalker;
import org.mule.datasense.impl.util.extension.ExtensionUtils;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.config.spring.api.dsl.model.ComponentModel;
import org.mule.runtime.config.spring.api.dsl.model.DslElementModel;

import java.util.Optional;

public abstract class StaticDslBaseAnnotator extends BaseOperationCallBuilderAnnotator {

  protected static class OperationCallDslElementModelVisitor implements DslElementModelVisitor {

    private final OperationCallBuilder operationCallBuilder;
    private boolean hasDynamicType;

    public OperationCallDslElementModelVisitor(OperationCallBuilder operationCallBuilder) {
      this.operationCallBuilder = operationCallBuilder;
      hasDynamicType = false;
    }

    @Override
    public void visitOperationModel(DslElementModel<OperationModel> operationModelDslElementModel,
                                    DslElementModelWalker dslElementModelWalker) {
      final OperationModel model = operationModelDslElementModel.getModel();
      operationCallBuilder.name(model.getName());
      operationModelDslElementModel.getContainedElements().forEach(dslElementModel -> {
        dslElementModelWalker.walkDslElementModel(dslElementModel, this);
      });
      operationCallBuilder.returnType(TypesHelper.getMessageMetadataTypeBuilder()
          .payload(model.getOutput().getType())
          .attributes(model.getOutputAttributes().getType()).build());
      hasDynamicType |= model.getOutput().hasDynamicType() || model.getOutputAttributes().hasDynamicType();
    }

    @Override
    public void visitSourceModel(DslElementModel<SourceModel> sourceModelDslElementModel,
                                 DslElementModelWalker dslElementModelWalker) {
      final SourceModel model = sourceModelDslElementModel.getModel();
      operationCallBuilder.name(model.getName());
      sourceModelDslElementModel.getContainedElements().forEach(dslElementModel -> {
        dslElementModelWalker.walkDslElementModel(dslElementModel, this);
      });
      operationCallBuilder.returnType(TypesHelper.getMessageMetadataTypeBuilder()
          .payload(model.getOutput().getType())
          .attributes(model.getOutputAttributes().getType()).build());
      hasDynamicType |= model.getOutput().hasDynamicType() || model.getOutputAttributes().hasDynamicType();
    }

    private void addParameter(String name, MetadataType metadataType, String value) {
      ExpressionLanguageUtils.extractExpression(value).ifPresent(expression -> {
        operationCallBuilder.input(inputMappingBuilder -> {
          inputMappingBuilder
              .parameter(inputParameterBuilder -> {
                inputParameterBuilder
                    .name(name)
                    .type(metadataType);
              })
              .argument(inputArgumentBuilder -> {
                inputArgumentBuilder.expression(expression);
              });
        });
      });
    }

    @Override
    public void visitParameterGroupModel(DslElementModel<ParameterGroupModel> parameterGroupModelDslElementModel,
                                         DslElementModelWalker dslElementModelWalker) {
      parameterGroupModelDslElementModel.getContainedElements().forEach(dslElementModel -> {
        dslElementModelWalker.walkDslElementModel(dslElementModel, this);
      });
    }

    @Override
    public void visitParameterModel(DslElementModel<ParameterModel> parameterModelDslElementModel,
                                    DslElementModelWalker dslElementModelWalker) {
      final ParameterModel parameterModel = parameterModelDslElementModel.getModel();
      hasDynamicType |= parameterModel.hasDynamicType();

      final Optional<String> valueOptional = parameterModelDslElementModel.getValue();
      if (valueOptional.isPresent()) {
        addParameter(parameterModel.getName(), parameterModel.getType(), valueOptional.get());
      } else {
        parameterModelDslElementModel.getContainedElements().forEach(dslElementModel -> {
          dslElementModelWalker.walkDslElementModel(dslElementModel, this);
        });
      }
    }

    @Override
    public void visitMetadataType(DslElementModel<MetadataType> metadataTypeDslElementModel,
                                  DslElementModelWalker dslElementModelWalker) {
      final MetadataType model = metadataTypeDslElementModel.getModel();
      final Optional<String> valueOptional = metadataTypeDslElementModel.getValue();
      if (valueOptional.isPresent()) {
        MetadataType type;
        if (model instanceof ObjectFieldType) {
          type = ((ObjectFieldType) model).getValue();
        } else {
          type = model;
        }
        addParameter(metadataTypeDslElementModel.getIdentifier().map(componentIdentifier -> componentIdentifier.getName())
            .orElse(""), type, valueOptional.get());
      } else {
        metadataTypeDslElementModel.getContainedElements().forEach(dslElementModel -> {
          dslElementModelWalker.walkDslElementModel(dslElementModel, this);
        });
      }
    }

    public boolean isHasDynamicType() {
      return hasDynamicType;
    }
  }

  //  protected Optional<String> findTarget(MessageProcessorNode messageProcessorNode) {
  //    return ExtensionUtils.findTarget(messageProcessorNode.getComponentModel());
  //  }
  //
  //  protected Optional<String> findTarget(DslElementModel<ParameterizedModel> dslElementModel) {
  //    return ExtensionUtils.findParameter(dslElementModel.getModel(), ExtensionUtils.PARAMETER_TARGET).map(parameterModel -> {
  //      return ExtensionUtils.findTarget(dslElementModel.getConfiguration());
  //    });
  //  }
}
