package org.mule.datasense.impl.phases.annotators;

import org.mule.datasense.impl.DataSenseProviderResolver;
import org.mule.datasense.impl.model.annotations.metadata.SourceModelAnnotation;
import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.phases.typing.AnnotatingMuleAstVisitorContext;
import org.mule.runtime.config.spring.api.dsl.model.ComponentModel;

import java.util.Optional;

public class StaticSourceAnnotator extends BaseStaticAnnotator {

  @Override
  protected Optional<org.mule.runtime.api.meta.model.ComponentModel> resolveComponentModel(
                                                                                           MessageProcessorNode messageProcessorNode,
                                                                                           AnnotatingMuleAstVisitorContext annotatingMuleAstVisitorContext,
                                                                                           DataSenseProviderResolver dataSenseProviderResolver,
                                                                                           ComponentModel componentModel) {
    return dataSenseProviderResolver.resolveSourceModel(componentModel)
        .map(sourceModel -> {
          messageProcessorNode.annotate(new SourceModelAnnotation(sourceModel));
          return (org.mule.runtime.api.meta.model.ComponentModel) sourceModel;
        });
  }
}
