package org.mule.datasense.impl.phases.builder;

import org.mule.datasense.api.ConfigResolutionScope;
import org.mule.runtime.config.spring.api.dsl.model.ComponentModel;

public class ConfigResolutionScopeStrategy implements DataSenseResolutionScopeStrategy {

  private final ConfigResolutionScope dataSenseResolutionScope;

  public ConfigResolutionScopeStrategy(ConfigResolutionScope dataSenseResolutionScope) {
    this.dataSenseResolutionScope = dataSenseResolutionScope;
  }

  @Override
  public boolean match(ComponentModel componentModel) {
    return componentModel.getComponentLocation().getFileName().map(s -> s.equals(dataSenseResolutionScope.getMuleConfig()))
        .orElse(false);
  }
}
