package org.mule.datasense.impl.phases.typing.resolver;

import org.mule.datasense.impl.model.annotations.DefinesTypeAnnotation;
import org.mule.datasense.impl.model.annotations.UsesTypeAnnotation;
import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.model.types.EventType;
import org.mule.datasense.impl.model.types.TypeUtils;
import org.mule.datasense.impl.model.types.TypesHelper;
import org.mule.datasense.impl.phases.builder.ComponentModelType;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitor;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitorContext;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.message.MessageMetadataType;
import org.mule.metadata.message.MessageMetadataTypeBuilder;
import org.mule.metadata.message.MuleEventMetadataTypeBuilder;

import java.util.Optional;

import static org.mule.datasense.impl.model.types.TypeUtils.getMessageMetadataType;

public class CollectionSplitterTypeResolver extends SingleNodeTypeResolver {

  @Override
  public Optional<ComponentModelType> getComponentModelType() {
    return Optional.of(ComponentModelType.MESSAGE_PROCESSOR_NODE);
  }

  private EventType getUsesEventType(EventType inputEventType) {
    MuleEventMetadataTypeBuilder muleEventMetadataTypeBuilder = TypesHelper.getMuleEventMetadataTypeBuilder();
    final MessageMetadataTypeBuilder defaultMessageMetadataTypeBuilder = TypesHelper.getMessageMetadataTypeBuilder();
    defaultMessageMetadataTypeBuilder.payload().arrayType().of().anyType();
    muleEventMetadataTypeBuilder.message((MessageMetadataType) TypeUtils
        .override(defaultMessageMetadataTypeBuilder.build(), TypeUtils.getMessageMetadataType(inputEventType).orElse(null)));
    return TypeUtils.asEventType(muleEventMetadataTypeBuilder.build());
  }

  private EventType getDefinesEventType(EventType usesEventType) {
    final MessageMetadataType usesMessageMetadataType = getMessageMetadataType(usesEventType).orElseThrow(
                                                                                                          IllegalArgumentException::new);

    MetadataType payloadType = usesMessageMetadataType.getPayloadType()
        .filter(metadataType -> metadataType instanceof ArrayType)
        .map(metadataType -> ((ArrayType) metadataType).getType())
        .orElse(TypesHelper.getTypeBuilder().anyType().build());

    MuleEventMetadataTypeBuilder muleEventMetadataTypeBuilder = TypesHelper.getMuleEventMetadataTypeBuilder();
    muleEventMetadataTypeBuilder.message((MessageMetadataType) TypeUtils
        .override(usesMessageMetadataType, new MessageMetadataTypeBuilder().payload(payloadType).build()));
    return TypeUtils.asEventType(muleEventMetadataTypeBuilder.build());
  }

  @Override
  protected EventType resolve(MessageProcessorNode messageProcessorNode, EventType inputEventType,
                              TypingMuleAstVisitor typingMuleAstVisitor,
                              TypingMuleAstVisitorContext visitorContext) {
    final EventType usesEventType = getUsesEventType(inputEventType);
    messageProcessorNode.annotate(new UsesTypeAnnotation(usesEventType));
    messageProcessorNode.annotate(new DefinesTypeAnnotation(getDefinesEventType(usesEventType)));
    return inputEventType;
  }

  @Override
  protected boolean isPropagates(MessageProcessorNode messageProcessorNode) {
    return true;
  }
}
