package org.mule.datasense.impl.phases.typing.resolver;

import static org.mule.datasense.impl.DefaultDataSense.COMPONENT_IDENTIFIER_ASYNC;
import static org.mule.datasense.impl.DefaultDataSense.COMPONENT_IDENTIFIER_ASYNC_SCOPE_IN;
import static org.mule.datasense.impl.DefaultDataSense.COMPONENT_IDENTIFIER_ASYNC_SCOPE_OUT;
import static org.mule.datasense.impl.DefaultDataSense.COMPONENT_IDENTIFIER_CHOICE;
import static org.mule.datasense.impl.DefaultDataSense.COMPONENT_IDENTIFIER_COLLECTION_SPLITTER;
import static org.mule.datasense.impl.DefaultDataSense.COMPONENT_IDENTIFIER_EE_CACHE;
import static org.mule.datasense.impl.DefaultDataSense.COMPONENT_IDENTIFIER_ENRICHER;
import static org.mule.datasense.impl.DefaultDataSense.COMPONENT_IDENTIFIER_ERROR_HANDLER;
import static org.mule.datasense.impl.DefaultDataSense.COMPONENT_IDENTIFIER_FIRST_SUCCESSFUL;
import static org.mule.datasense.impl.DefaultDataSense.COMPONENT_IDENTIFIER_FLOW;
import static org.mule.datasense.impl.DefaultDataSense.COMPONENT_IDENTIFIER_FLOW_REF;
import static org.mule.datasense.impl.DefaultDataSense.COMPONENT_IDENTIFIER_FLOW_SCOPE_IN;
import static org.mule.datasense.impl.DefaultDataSense.COMPONENT_IDENTIFIER_FLOW_SCOPE_OUT;
import static org.mule.datasense.impl.DefaultDataSense.COMPONENT_IDENTIFIER_FOREACH;
import static org.mule.datasense.impl.DefaultDataSense.COMPONENT_IDENTIFIER_FOREACH_SCOPE_IN;
import static org.mule.datasense.impl.DefaultDataSense.COMPONENT_IDENTIFIER_LOGGER;
import static org.mule.datasense.impl.DefaultDataSense.COMPONENT_IDENTIFIER_ON_ERROR_CONTINUE;
import static org.mule.datasense.impl.DefaultDataSense.COMPONENT_IDENTIFIER_ON_ERROR_PROPAGATE;
import static org.mule.datasense.impl.DefaultDataSense.COMPONENT_IDENTIFIER_ON_ERROR_SCOPE_IN;
import static org.mule.datasense.impl.DefaultDataSense.COMPONENT_IDENTIFIER_OPERATION_CALL;
import static org.mule.datasense.impl.DefaultDataSense.COMPONENT_IDENTIFIER_OTHERWISE;
import static org.mule.datasense.impl.DefaultDataSense.COMPONENT_IDENTIFIER_PARSE_TEMPLATE;
import static org.mule.datasense.impl.DefaultDataSense.COMPONENT_IDENTIFIER_REMOVE_VARIABLE;
import static org.mule.datasense.impl.DefaultDataSense.COMPONENT_IDENTIFIER_ROUND_ROBIN;
import static org.mule.datasense.impl.DefaultDataSense.COMPONENT_IDENTIFIER_ROUTE;
import static org.mule.datasense.impl.DefaultDataSense.COMPONENT_IDENTIFIER_SCHEDULER;
import static org.mule.datasense.impl.DefaultDataSense.COMPONENT_IDENTIFIER_PROCESSOR_CHAIN;
import static org.mule.datasense.impl.DefaultDataSense.COMPONENT_IDENTIFIER_SCATTER_GATHER;
import static org.mule.datasense.impl.DefaultDataSense.COMPONENT_IDENTIFIER_SET_PAYLOAD;
import static org.mule.datasense.impl.DefaultDataSense.COMPONENT_IDENTIFIER_SET_PAYLOAD_ATTRIBUTES;
import static org.mule.datasense.impl.DefaultDataSense.COMPONENT_IDENTIFIER_SET_VARIABLE;
import static org.mule.datasense.impl.DefaultDataSense.COMPONENT_IDENTIFIER_SUBFLOW;
import static org.mule.datasense.impl.DefaultDataSense.COMPONENT_IDENTIFIER_TRANSFORM;
import static org.mule.datasense.impl.DefaultDataSense.COMPONENT_IDENTIFIER_TRY;
import static org.mule.datasense.impl.DefaultDataSense.COMPONENT_IDENTIFIER_UNKNOWN_PROCESSOR;
import static org.mule.datasense.impl.DefaultDataSense.COMPONENT_IDENTIFIER_UNTIL_SUCCESSFUL;
import static org.mule.datasense.impl.DefaultDataSense.COMPONENT_IDENTIFIER_UNTIL_SUCCESSFUL_SCOPE_IN;
import static org.mule.datasense.impl.DefaultDataSense.COMPONENT_IDENTIFIER_UNTIL_SUCCESSFUL_SCOPE_OUT;
import static org.mule.datasense.impl.DefaultDataSense.COMPONENT_IDENTIFIER_WHEN;

public class DataSenseTypeResolverRegistry extends TypeResolverRegistry {

  public DataSenseTypeResolverRegistry() {
    register(COMPONENT_IDENTIFIER_FLOW, new FlowTypeResolver());
    register(COMPONENT_IDENTIFIER_FLOW_SCOPE_IN, new FlowTypeResolver.ScopeIn());
    register(COMPONENT_IDENTIFIER_FLOW_SCOPE_OUT, new FlowTypeResolver.ScopeOut());
    register(COMPONENT_IDENTIFIER_SUBFLOW, new FlowTypeResolver());
    register(COMPONENT_IDENTIFIER_LOGGER, new LoggerTypeResolver());
    register(COMPONENT_IDENTIFIER_COLLECTION_SPLITTER, new CollectionSplitterTypeResolver());
    register(COMPONENT_IDENTIFIER_SCHEDULER, new SchedulerTypeResolver());
    register(COMPONENT_IDENTIFIER_TRANSFORM, new TransformTypeResolver());
    register(COMPONENT_IDENTIFIER_OPERATION_CALL, new OperationCallTypeResolver());
    register(COMPONENT_IDENTIFIER_SET_PAYLOAD_ATTRIBUTES, new SetPayloadAttributesTypeResolver());
    register(COMPONENT_IDENTIFIER_SET_PAYLOAD, new SetPayloadTypeResolver());
    register(COMPONENT_IDENTIFIER_SET_VARIABLE, new SetVariableTypeResolver());
    register(COMPONENT_IDENTIFIER_REMOVE_VARIABLE, new RemoveVariableTypeResolver());
    register(COMPONENT_IDENTIFIER_PROCESSOR_CHAIN, new ProcessorChainTypeResolver());
    register(COMPONENT_IDENTIFIER_UNKNOWN_PROCESSOR, new UnknownProcessorTypeResolver());
    register(COMPONENT_IDENTIFIER_PARSE_TEMPLATE, new ParseTemplateTypeResolver());

    // Router: Choice
    register(COMPONENT_IDENTIFIER_CHOICE, new ChoiceTypeResolver());
    register(COMPONENT_IDENTIFIER_WHEN, new ChoiceTypeResolver.ChoiceWhenTypeResolver());
    register(COMPONENT_IDENTIFIER_OTHERWISE, new ChoiceTypeResolver.ChoiceOtherwiseTypeResolver());
    // Router: Enricher
    register(COMPONENT_IDENTIFIER_ENRICHER, new EnricherTypeResolver());
    // Router: ForEach
    register(COMPONENT_IDENTIFIER_FOREACH, new ForEachTypeResolver());
    register(COMPONENT_IDENTIFIER_FOREACH_SCOPE_IN, new ForEachTypeResolver.ForEachScopeIn());
    // Router: ScatterGather
    register(COMPONENT_IDENTIFIER_SCATTER_GATHER, new ScatterGatherTypeResolver());
    register(COMPONENT_IDENTIFIER_ROUTE, new RouteTypeResolver());

    register(COMPONENT_IDENTIFIER_FLOW_REF, new FlowRefTypeResolver());
    // try
    register(COMPONENT_IDENTIFIER_TRY, new TryTypeResolver());
    register(COMPONENT_IDENTIFIER_ERROR_HANDLER, new ErrorHandlerTypeResolver());
    register(COMPONENT_IDENTIFIER_ON_ERROR_CONTINUE, new OnErrorTypeResolver());
    register(COMPONENT_IDENTIFIER_ON_ERROR_PROPAGATE, new OnErrorTypeResolver());
    register(COMPONENT_IDENTIFIER_ON_ERROR_SCOPE_IN, new OnErrorTypeResolver.ScopeIn());
    // Other Scopes
    register(COMPONENT_IDENTIFIER_FIRST_SUCCESSFUL, new FirstSuccessfulTypeResolver());
    register(COMPONENT_IDENTIFIER_UNTIL_SUCCESSFUL,
             new UntilSuccessfulTypeResolver(COMPONENT_IDENTIFIER_UNTIL_SUCCESSFUL_SCOPE_IN,
                                             COMPONENT_IDENTIFIER_UNTIL_SUCCESSFUL_SCOPE_OUT));
    register(COMPONENT_IDENTIFIER_UNTIL_SUCCESSFUL_SCOPE_IN, new UntilSuccessfulTypeResolver.ScopeIn());
    register(COMPONENT_IDENTIFIER_UNTIL_SUCCESSFUL_SCOPE_OUT, new UntilSuccessfulTypeResolver.ScopeOut());
    register(COMPONENT_IDENTIFIER_ROUND_ROBIN, new RoundRobinTypeResolver());
    register(COMPONENT_IDENTIFIER_ASYNC,
             new AsyncTypeResolver(COMPONENT_IDENTIFIER_ASYNC_SCOPE_IN, COMPONENT_IDENTIFIER_ASYNC_SCOPE_OUT));
    register(COMPONENT_IDENTIFIER_ASYNC_SCOPE_IN, new AsyncTypeResolver.ScopeIn());
    register(COMPONENT_IDENTIFIER_ASYNC_SCOPE_OUT, new AsyncTypeResolver.ScopeOut());
    register(COMPONENT_IDENTIFIER_EE_CACHE, new EECacheTypeResolver());
  }
}
