package org.mule.datasense.impl.phases.typing.resolver;

import org.mule.datasense.impl.model.annotations.DefinesTypeAnnotation;
import org.mule.datasense.impl.model.annotations.MuleApplicationAnnotation;
import org.mule.datasense.impl.model.annotations.UsesTypeAnnotation;
import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.model.ast.MuleApplicationNode;
import org.mule.datasense.impl.model.ast.MuleFlowNode;
import org.mule.datasense.impl.model.reporting.NotificationMessages;
import org.mule.datasense.impl.model.types.EventType;
import org.mule.datasense.impl.phases.builder.ComponentModelType;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitor;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitorContext;
import org.mule.runtime.api.i18n.I18nMessageFactory;

import java.util.Optional;

public class FlowRefTypeResolver extends SingleNodeTypeResolver {

  @Override
  public Optional<ComponentModelType> getComponentModelType() {
    return Optional.of(ComponentModelType.MESSAGE_PROCESSOR_NODE);
  }

  @Override
  protected EventType resolve(MessageProcessorNode messageProcessorNode, EventType inputEventType,
                              TypingMuleAstVisitor typingMuleAstVisitor,
                              TypingMuleAstVisitorContext visitorContext) {

    Optional<UsesTypeAnnotation> usesTypeAnnotation = Optional.empty();
    Optional<DefinesTypeAnnotation> definesTypeAnnotation = Optional.empty();

    final String referredFlowName = messageProcessorNode.getComponentModel().getNameAttribute();
    final MuleApplicationNode muleApplicationNode = visitorContext.getAnnotation(MuleApplicationAnnotation.class)
        .map(MuleApplicationAnnotation::getMuleApplicationNode)
        .orElseThrow(() -> new IllegalArgumentException("Mule application node not set."));
    final MuleFlowNode muleFlowNode = muleApplicationNode.findMuleFlowNode(referredFlowName).orElse(null);
    if (muleFlowNode != null) {
      usesTypeAnnotation = muleFlowNode.getAnnotation(UsesTypeAnnotation.class);
      definesTypeAnnotation = muleFlowNode.getAnnotation(DefinesTypeAnnotation.class);
    } else {
      visitorContext.getAstNotification().reportError(messageProcessorNode.getAstNodeLocation(), I18nMessageFactory
          .createStaticMessage(NotificationMessages.MSG_FAILED_TO_RESOLVE_FLOWREF, referredFlowName));
    }
    messageProcessorNode.annotate(usesTypeAnnotation.orElse(new UsesTypeAnnotation(new EventType())));
    messageProcessorNode.annotate(definesTypeAnnotation.orElse(new DefinesTypeAnnotation(new EventType())));

    return messageProcessorNode.getAnnotation(DefinesTypeAnnotation.class).map(
                                                                               DefinesTypeAnnotation::getDefinesEventType)
        .orElse(new EventType());
  }

  @Override
  protected boolean isPropagates(MessageProcessorNode messageProcessorNode) {
    return true;
  }
}
