package org.mule.datasense.impl.phases.typing.resolver;

import org.mule.datasense.impl.model.annotations.DefinesTypeAnnotation;
import org.mule.datasense.impl.model.annotations.UsesTypeAnnotation;
import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.model.types.EventType;
import org.mule.datasense.impl.phases.builder.AstNodeBuilder;
import org.mule.datasense.impl.phases.builder.ComponentModelType;
import org.mule.datasense.impl.phases.builder.MessageProcessorNodeBuilder;
import org.mule.datasense.impl.phases.builder.MuleAstParseProvider;
import org.mule.datasense.impl.phases.scoping.IncomingAstVisitor;
import org.mule.datasense.impl.phases.scoping.IncomingAstVisitorContext;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitor;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitorContext;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.config.spring.api.dsl.model.ComponentModel;

import java.util.List;
import java.util.Optional;

import static org.mule.datasense.impl.DefaultDataSense.COMPONENT_IDENTIFIER_ON_ERROR_SCOPE_IN;

public class OnErrorTypeResolver extends ProcessorChainTypeResolver {

  @Override
  protected boolean isPropagates(MessageProcessorNode messageProcessorNode) {
    return true;
  }

  @Override
  public Optional<MuleAstParseProvider> getParseProvider() {
    return Optional.of(
                       (componentIdentifier, componentModel, componentModelType, messageProcessorNodeBuilders,
                        muleAstParserContext) -> {
                         return generateAst(componentIdentifier, componentModel, componentModelType,
                                            messageProcessorNodeBuilders);
                       });
  }

  private Optional<AstNodeBuilder> generateAst(ComponentIdentifier componentIdentifier, ComponentModel componentModel,
                                               ComponentModelType componentModelType,
                                               List<MessageProcessorNodeBuilder> messageProcessorNodeBuilders) {
    MessageProcessorNodeBuilder messageProcessorNodeBuilder = new MessageProcessorNodeBuilder(componentIdentifier);
    messageProcessorNodeBuilder.config(componentModel);
    messageProcessorNodeBuilder.componentModelType(componentModelType);
    messageProcessorNodeBuilder.messageProcessor(COMPONENT_IDENTIFIER_ON_ERROR_SCOPE_IN, m -> {
      m.config(componentModel);
      m.synthetic();
    });
    messageProcessorNodeBuilders
        .forEach(messageProcessorNodeBuilder::messageProcessor);

    return Optional.of(messageProcessorNodeBuilder);
  }

  public static class ScopeIn extends SingleNodeTypeResolver {

    @Override
    protected EventType resolve(MessageProcessorNode messageProcessorNode, EventType inputEventType,
                                TypingMuleAstVisitor typingMuleAstVisitor, TypingMuleAstVisitorContext visitorContext) {
      messageProcessorNode.annotate(new UsesTypeAnnotation(new EventType()));
      messageProcessorNode.annotate(new DefinesTypeAnnotation(new EventType()));
      return new EventType();
    }


    @Override
    public EventType generateIncoming(MessageProcessorNode messageProcessorNode, IncomingAstVisitor incomingAstVisitor,
                                      IncomingAstVisitorContext visitorContext) {
      return super.generateIncoming(messageProcessorNode, incomingAstVisitor, visitorContext);
    }

    @Override
    protected boolean isPropagates(MessageProcessorNode messageProcessorNode) {
      return false;
    }

    @Override
    protected boolean isScope() {
      return true;
    }
  }


}
