package org.mule.datasense.impl.phases.typing.resolver;

import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.model.event.MuleEventExprBuilder;
import org.mule.datasense.impl.model.event.SimpleExprBuilder;
import org.mule.datasense.impl.model.types.EventType;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitor;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitorContext;

import java.util.function.Consumer;

public class SetPayloadAttributesTypeResolver extends SetPayloadTypeResolver {

  @Override
  protected Consumer<MuleEventExprBuilder> getMuleEventExprBuilderConsumer(MessageProcessorNode messageProcessorNode,
                                                                           EventType inputEventType,
                                                                           TypingMuleAstVisitor typingMuleAstVisitor,
                                                                           TypingMuleAstVisitorContext visitorContext) {
    return (muleEventExprBuilder) -> {
      final String expression = getVarDeclValue(messageProcessorNode);
      muleEventExprBuilder.message(m -> m.value(m1 -> m1.attributes(new SimpleExprBuilder(expression))));
    };
  }
}
