package org.mule.datasense.impl.phases.typing.resolver;

import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.model.event.MuleEventExprBuilder;
import org.mule.datasense.impl.model.event.SimpleExprBuilder;
import org.mule.datasense.impl.model.event.ValueExprBuilder;
import org.mule.datasense.impl.model.types.EventType;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitor;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitorContext;
import org.mule.datasense.impl.util.ExpressionLanguageUtils;

import java.util.Optional;
import java.util.function.Consumer;

import static java.util.Optional.ofNullable;

public class SetVariableTypeResolver extends SetDataTypeResolver {

  private final static String FIELD_VALUE = "value";
  private final static String FIELD_VARIABLE = "variableName";
  private final static String TYPE_DEFAULT_EXPRESSION = "''";

  @Override
  protected Consumer<MuleEventExprBuilder> getMuleEventExprBuilderConsumer(MessageProcessorNode messageProcessorNode,
                                                                           EventType inputEventType,
                                                                           TypingMuleAstVisitor typingMuleAstVisitor,
                                                                           TypingMuleAstVisitorContext visitorContext) {
    return (muleEventExprBuilder) -> {
      getVarDeclName(messageProcessorNode).ifPresent(variableName -> {
        final String expression = getVarDeclValue(messageProcessorNode);
        muleEventExprBuilder.variable(variableName, v -> {
          v.value(new ValueExprBuilder(new SimpleExprBuilder(expression)));
        });
      });
    };
  }

  protected Optional<String> getVarDeclName(MessageProcessorNode messageProcessorNode) {
    return ofNullable(messageProcessorNode.getComponentModel().getParameters().get(FIELD_VARIABLE));
  }

  protected String getVarDeclValue(MessageProcessorNode messageProcessorNode) {
    return ExpressionLanguageUtils.extractExpression(messageProcessorNode.getComponentModel().getParameters().get(FIELD_VALUE))
        .orElse(TYPE_DEFAULT_EXPRESSION);
  }
}
