package org.mule.datasense.impl.util;

import org.mule.datasense.impl.model.types.EventType;
import org.mule.datasense.impl.model.types.TypeUtils;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.message.MuleEventMetadataType;
import org.mule.metadata.message.MuleEventMetadataTypeBuilder;
import org.mule.metadata.message.el.ExpressionLanguageMetadataTypeResolver;

import java.util.Optional;

public class ExpressionLanguageUtils {

  public static final String EXPRESSION_PREFIX = "#[";
  public static final String EXPRESSION_POSTFIX = "]";

  public static boolean isExpression(String value) {
    boolean result = false;
    if (!(value == null || value.isEmpty())) {
      String trimmedText = value.trim();
      result = (trimmedText.startsWith("#[") && trimmedText.endsWith("]"));
    }
    return result;
  }

  public static Optional<String> extractExpression(String value) {
    Optional<String> result = Optional.empty();

    if (!(value == null || value.isEmpty())) {
      String trimmedText = value.trim();
      if (trimmedText.startsWith("#[") && trimmedText.endsWith("]")) {
        result = Optional.of(trimmedText.substring(2, trimmedText.length() - 1));
      }
    }

    return result;
  }

  public static String toExpression(String expression) {
    return EXPRESSION_PREFIX + expression + EXPRESSION_POSTFIX;
  }

  public static MetadataType resolveExpressionType(String expression, MuleEventMetadataType muleEventMetadataType,
                                                   ExpressionLanguageMetadataTypeResolver expressionLanguageMetadataTypeResolver,
                                                   ExpressionLanguageMetadataTypeResolver.MessageCallback messageCallback) {
    return expressionLanguageMetadataTypeResolver.getOutputType(muleEventMetadataType, expression, messageCallback);
  }

  public static MetadataType resolveExpressionType(String expression, EventType inputEventType,
                                                   ExpressionLanguageMetadataTypeResolver expressionLanguageMetadataTypeResolver,
                                                   ExpressionLanguageMetadataTypeResolver.MessageCallback messageCallback) {
    return resolveExpressionType(expression, TypeUtils.asMuleEventMetadataType(inputEventType).build(),
                                 expressionLanguageMetadataTypeResolver, messageCallback);
  }

  public static void resolveInputEventType(String expression,
                                           ExpressionLanguageMetadataTypeResolver expressionLanguageMetadataTypeResolver,
                                           MetadataType metadataType,
                                           MuleEventMetadataTypeBuilder muleEventMetadataTypeBuilder,
                                           ExpressionLanguageMetadataTypeResolver.MessageCallback messageCallback) {
    expressionLanguageMetadataTypeResolver
        .getInputType(expression, metadataType, muleEventMetadataTypeBuilder, messageCallback);
  }

}
