package org.mule.datasense.impl.util.extension;

import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.config.spring.api.dsl.model.ComponentModel;
import org.mule.runtime.config.spring.api.dsl.model.DslElementModel;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;

public class ExtensionUtils {

  public static final String PARAMETER_TARGET = "target";
  public static final String PARAMETER_TARGET_VALUE = "targetValue";

  private static List<String> RESERVED_PARAMETERS = Arrays.asList(PARAMETER_TARGET, PARAMETER_TARGET_VALUE);

  public static boolean isOutputParameter(String parameter) {
    return RESERVED_PARAMETERS.contains(parameter);
  }

  public static Optional<String> findParameter(ComponentModel componentModel, String parameter) {
    String result = null;
    if (componentModel != null) {
      result = componentModel.getParameters().get(parameter);
    }
    return Optional.ofNullable(result);
  }

  public static Optional<ParameterModel> findParameter(ParameterizedModel parameterizedModel, String parameter) {
    return parameterizedModel
        .getAllParameterModels()
        .stream()
        .filter(parameterModel -> parameterModel.getName().equals(parameter))
        .findFirst();
  }

  public static Optional<String> findDefaultTargetValue(ParameterizedModel parameterizedModel) {
    final Object defaultTargetValue = findParameter(parameterizedModel, PARAMETER_TARGET_VALUE)
        .map(ParameterModel::getDefaultValue)
        .orElse(null);
    return Optional.ofNullable(defaultTargetValue instanceof String ? (String) defaultTargetValue : null);
  }

  public static Optional<String> findTarget(ComponentModel componentModel) {
    return findParameter(componentModel, ExtensionUtils.PARAMETER_TARGET);
  }

  public static Optional<String> findTargetValue(ComponentModel componentModel) {
    return findParameter(componentModel, ExtensionUtils.PARAMETER_TARGET_VALUE);
  }
}
