package org.mule.datasense.impl.util.extension;

import org.mule.runtime.api.meta.model.source.SourceCallbackModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.extension.api.model.source.ImmutableSourceModel;

import java.util.Optional;

public class SourceModelTransform extends EntityModelTransform {

  private final SourceCallbackModelTransform successSourceCallbackModelTransform;
  private final SourceCallbackModelTransform errorSourceCallbackModelTransform;
  private final SourceCallbackModelTransform terminateSourceCallbackModelTransform;

  public SourceModelTransform(
                              ParameterGroupModelTransform parameterGroupModelTransform,
                              OutputModelTransform outputModelTransform,
                              OutputModelTransform outputAttributesModelTransform,
                              SourceCallbackModelTransform successSourceCallbackModelTransform,
                              SourceCallbackModelTransform errorSourceCallbackModelTransform,
                              SourceCallbackModelTransform terminateSourceCallbackModelTransform) {
    super(parameterGroupModelTransform, outputModelTransform, outputAttributesModelTransform);
    this.successSourceCallbackModelTransform = successSourceCallbackModelTransform;
    this.errorSourceCallbackModelTransform = errorSourceCallbackModelTransform;
    this.terminateSourceCallbackModelTransform = terminateSourceCallbackModelTransform;
  }

  public SourceModel transform(SourceModel sourceModel) {
    final Optional<SourceCallbackModel> successSourceCallbackModel = sourceModel.getSuccessCallback()
        .map(originalSourceCallbackModel -> successSourceCallbackModelTransform.transform(originalSourceCallbackModel));
    final Optional<SourceCallbackModel> errorSourceCallbackModel = sourceModel.getErrorCallback()
        .map(originalSourceCallbackModel -> errorSourceCallbackModelTransform.transform(originalSourceCallbackModel));
    final Optional<SourceCallbackModel> terminateSourceCallbackModel = sourceModel.getTerminateCallback()
        .map(originalSourceCallbackModel -> terminateSourceCallbackModelTransform.transform(originalSourceCallbackModel));

    return new ImmutableSourceModel(sourceModel.getName(), sourceModel.getDescription(), sourceModel.hasResponse(),
                                    parameterGroupModelTransform.transform(sourceModel.getParameterGroupModels()),
                                    sourceModel.getNestedComponents(),
                                    outputModelTransform.transform(sourceModel.getOutput()),
                                    outputAttributesModelTransform.transform(sourceModel.getOutputAttributes()),
                                    successSourceCallbackModel,
                                    errorSourceCallbackModel,
                                    terminateSourceCallbackModel,
                                    sourceModel.requiresConnection(),
                                    sourceModel.isTransactional(),
                                    sourceModel.supportsStreaming(),
                                    sourceModel.getDisplayModel().orElse(null),
                                    sourceModel.getStereotype(),
                                    sourceModel.getErrorModels(),
                                    sourceModel.getModelProperties());

  }
}
