/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.phases.annotators;

import org.mule.datasense.api.metadataprovider.DataSenseMetadataProvider;
import org.mule.datasense.impl.model.annotations.ComponentLocationAnnotation;
import org.mule.datasense.impl.model.annotations.metadata.OperationModelAnnotation;
import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.phases.annotators.BaseDynamicAnnotator;
import org.mule.datasense.impl.phases.typing.AnnotatingMuleAstVisitorContext;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.metadata.descriptor.ComponentMetadataDescriptor;
import org.mule.runtime.api.metadata.resolving.MetadataResult;

public class DynamicOperationAnnotator
extends BaseDynamicAnnotator<OperationModel> {
    @Override
    protected MetadataResult<ComponentMetadataDescriptor<OperationModel>> resolveMetadata(MessageProcessorNode messageProcessorNode, DataSenseMetadataProvider dataSenseMetadataProvider, ComponentLocationAnnotation componentLocationAnnotation, AnnotatingMuleAstVisitorContext annotatingMuleAstVisitorContext) {
        MetadataResult<ComponentMetadataDescriptor<OperationModel>> operationMetadata = dataSenseMetadataProvider.getOperationMetadata(componentLocationAnnotation.getLocation());
        if (operationMetadata != null) {
            OperationModel operationModel;
            ComponentMetadataDescriptor operationModelComponentMetadataDescriptor = (ComponentMetadataDescriptor)operationMetadata.get();
            if (operationModelComponentMetadataDescriptor != null && (operationModel = (OperationModel)operationModelComponentMetadataDescriptor.getModel()) != null) {
                messageProcessorNode.annotate(new OperationModelAnnotation(operationModel));
            }
        } else {
            annotatingMuleAstVisitorContext.getAstNotification().reportError(messageProcessorNode.getAstNodeLocation(), I18nMessageFactory.createStaticMessage((String)"Failed to obtain dynamic metadata resolving request [%s].", (Object[])new Object[]{"operation metadata for component_path: " + componentLocationAnnotation.getLocation()}));
        }
        return operationMetadata;
    }
}

