/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.phases.annotators;

import java.util.Optional;
import org.mule.datasense.impl.model.operation.OperationCallBuilder;
import org.mule.datasense.impl.model.types.TypesHelper;
import org.mule.datasense.impl.phases.annotators.BaseOperationCallBuilderAnnotator;
import org.mule.datasense.impl.util.ExpressionLanguageUtils;
import org.mule.datasense.impl.util.extension.DslElementModelVisitor;
import org.mule.datasense.impl.util.extension.DslElementModelWalker;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.config.spring.api.dsl.model.DslElementModel;

public abstract class StaticDslBaseAnnotator
extends BaseOperationCallBuilderAnnotator {

    protected static class OperationCallDslElementModelVisitor
    implements DslElementModelVisitor {
        private final OperationCallBuilder operationCallBuilder;
        private boolean hasDynamicType;

        public OperationCallDslElementModelVisitor(OperationCallBuilder operationCallBuilder) {
            this.operationCallBuilder = operationCallBuilder;
            this.hasDynamicType = false;
        }

        @Override
        public void visitOperationModel(DslElementModel<OperationModel> operationModelDslElementModel, DslElementModelWalker dslElementModelWalker) {
            OperationModel model = (OperationModel)operationModelDslElementModel.getModel();
            this.operationCallBuilder.name(model.getName());
            operationModelDslElementModel.getContainedElements().forEach(dslElementModel -> dslElementModelWalker.walkDslElementModel((DslElementModel)dslElementModel, this));
            this.operationCallBuilder.returnType((MetadataType)TypesHelper.getMessageMetadataTypeBuilder().payload(model.getOutput().getType()).attributes(model.getOutputAttributes().getType()).build());
            this.hasDynamicType |= model.getOutput().hasDynamicType() || model.getOutputAttributes().hasDynamicType();
        }

        @Override
        public void visitSourceModel(DslElementModel<SourceModel> sourceModelDslElementModel, DslElementModelWalker dslElementModelWalker) {
            SourceModel model = (SourceModel)sourceModelDslElementModel.getModel();
            this.operationCallBuilder.name(model.getName());
            sourceModelDslElementModel.getContainedElements().forEach(dslElementModel -> dslElementModelWalker.walkDslElementModel((DslElementModel)dslElementModel, this));
            this.operationCallBuilder.returnType((MetadataType)TypesHelper.getMessageMetadataTypeBuilder().payload(model.getOutput().getType()).attributes(model.getOutputAttributes().getType()).build());
            this.hasDynamicType |= model.getOutput().hasDynamicType() || model.getOutputAttributes().hasDynamicType();
        }

        private void addParameter(String name, MetadataType metadataType, String value) {
            ExpressionLanguageUtils.extractExpression(value).ifPresent(expression -> this.operationCallBuilder.input(inputMappingBuilder -> inputMappingBuilder.parameter(inputParameterBuilder -> inputParameterBuilder.name(name).type(metadataType)).argument(inputArgumentBuilder -> inputArgumentBuilder.expression((String)expression))));
        }

        @Override
        public void visitParameterGroupModel(DslElementModel<ParameterGroupModel> parameterGroupModelDslElementModel, DslElementModelWalker dslElementModelWalker) {
            parameterGroupModelDslElementModel.getContainedElements().forEach(dslElementModel -> dslElementModelWalker.walkDslElementModel((DslElementModel)dslElementModel, this));
        }

        @Override
        public void visitParameterModel(DslElementModel<ParameterModel> parameterModelDslElementModel, DslElementModelWalker dslElementModelWalker) {
            ParameterModel parameterModel = (ParameterModel)parameterModelDslElementModel.getModel();
            this.hasDynamicType |= parameterModel.hasDynamicType();
            Optional valueOptional = parameterModelDslElementModel.getValue();
            if (valueOptional.isPresent()) {
                this.addParameter(parameterModel.getName(), parameterModel.getType(), (String)valueOptional.get());
            } else {
                parameterModelDslElementModel.getContainedElements().forEach(dslElementModel -> dslElementModelWalker.walkDslElementModel((DslElementModel)dslElementModel, this));
            }
        }

        @Override
        public void visitMetadataType(DslElementModel<MetadataType> metadataTypeDslElementModel, DslElementModelWalker dslElementModelWalker) {
            MetadataType model = (MetadataType)metadataTypeDslElementModel.getModel();
            Optional valueOptional = metadataTypeDslElementModel.getValue();
            if (valueOptional.isPresent()) {
                MetadataType type = model instanceof ObjectFieldType ? ((ObjectFieldType)model).getValue() : model;
                this.addParameter(metadataTypeDslElementModel.getIdentifier().map(componentIdentifier -> componentIdentifier.getName()).orElse(""), type, (String)valueOptional.get());
            } else {
                metadataTypeDslElementModel.getContainedElements().forEach(dslElementModel -> dslElementModelWalker.walkDslElementModel((DslElementModel)dslElementModel, this));
            }
        }

        public boolean isHasDynamicType() {
            return this.hasDynamicType;
        }
    }
}

