/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.datasense.impl.model.types;

import org.mule.datasense.impl.util.MetadataTypeWriter;
import org.mule.metadata.MetadataFormats;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.java.api.JavaTypeLoader;
import org.mule.metadata.message.api.MessageMetadataTypeBuilder;
import org.mule.metadata.message.api.MuleEventMetadataTypeBuilder;

import com.google.common.base.Preconditions;
import org.mule.weave.v2.el.metadata.WeaveTypeLoader;

import java.util.Optional;

/**
 *
 */
public class TypesHelper {

  public static final String PAYLOAD = "payload";
  public static final String ATTRIBUTES = "attributes";
  public static final String MESSAGE = "message";
  public static final String VARIABLES = "variables";

  public static final String MULE_EVENT_PAYLOAD = "#payload#";
  public static final String MULE_EVENT_ATTRIBUTES = "#attributes#";
  public static final String FUNCTION_INPUT_PARAMETER = "input";

  /**
   * @param metadataType
   * @return
   */
  public static MetadataType getType(MetadataType metadataType) {
    Preconditions.checkNotNull(metadataType);
    return metadataType != null ? metadataType : getTypeBuilder().nullType().build();
  }

  public static Optional<MetadataType> getTypeFromJavaClass(String clazz, ClassLoader classLoader) {
    return new JavaTypeLoader(classLoader).load(clazz);
  }

  public static Optional<MetadataType> getTypeFromWeave(String weaveTypeDef, String typeId, MetadataFormat metadataFormat) {
    WeaveTypeLoader weaveTypeLoader =
        new WeaveTypeLoader(weaveTypeDef, Optional.ofNullable(metadataFormat).orElse(MetadataFormats.JAVA));
    return weaveTypeLoader.load(typeId);
  }

  public static Optional<MetadataType> getTypeFromWeave(String weaveTypeDef, String typeId) {
    return getTypeFromWeave(weaveTypeDef, typeId, null);
  }

  public static BaseTypeBuilder getTypeBuilder() {
    return getTypeBuilder(MetadataFormat.JAVA);
  }

  public static MuleEventMetadataTypeBuilder getMuleEventMetadataTypeBuilder() {
    return new MuleEventMetadataTypeBuilder();
  }

  public static MessageMetadataTypeBuilder getMessageMetadataTypeBuilder() {
    return new MessageMetadataTypeBuilder();
  }

  public static BaseTypeBuilder getTypeBuilder(MetadataFormat metadataFormat) {
    return new BaseTypeBuilder(metadataFormat);
  }

  public static String toString(MetadataType metadataType) {
    return new MetadataTypeWriter().toString(metadataType);
  }

}
