/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.datasense.impl.model.types;

import com.google.common.base.Preconditions;
import org.mule.metadata.api.model.MetadataType;

/**
 *
 */
public class VarDecl {

  private final String name;
  private final MetadataType metadataType;

  public VarDecl(String name, MetadataType metadataType) {
    Preconditions.checkNotNull(name);
    Preconditions.checkNotNull(metadataType);
    this.name = name;
    this.metadataType = metadataType;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }

    VarDecl varDecl = (VarDecl) o;

    return name.equals(varDecl.name);

  }

  @Override
  public int hashCode() {
    return name.hashCode();
  }

  public String getName() {
    return name;
  }

  public MetadataType getType() {
    return metadataType;
  }

  @Override
  public String toString() {
    return "VarDecl{" +
        "name='" + name + '\'' +
        ", metadataType=" + TypesHelper.toString(metadataType) +
        '}';
  }
}
