package org.mule.datasense.impl.phases.annotators;

import org.mule.datasense.impl.model.annotations.MuleApplicationAnnotation;
import org.mule.datasense.impl.model.annotations.munit.MUnitDeclarationsAnnotation;
import org.mule.datasense.impl.model.ast.MuleApplicationNode;
import org.mule.datasense.impl.model.ast.MuleFlowNode;
import org.mule.datasense.impl.phases.typing.AnnotatingMuleAstVisitorContext;
import org.mule.runtime.api.component.ComponentIdentifier;

import static org.mule.datasense.impl.DefaultDataSense.COMPONENT_IDENTIFIER_MUNIT_AFTER_SUITE;
import static org.mule.datasense.impl.DefaultDataSense.COMPONENT_IDENTIFIER_MUNIT_AFTER_TEST;
import static org.mule.datasense.impl.DefaultDataSense.COMPONENT_IDENTIFIER_MUNIT_BEFORE_SUITE;
import static org.mule.datasense.impl.DefaultDataSense.COMPONENT_IDENTIFIER_MUNIT_BEFORE_TEST;

public class MUnitDeclarationAnnotator implements Annotator {

  @Override
  public void annotate(MuleFlowNode muleFlowNode, AnnotatingMuleAstVisitorContext annotatingMuleAstVisitorContext) {
    final ComponentIdentifier componentIdentifier = muleFlowNode.getIdentifier();
    if (COMPONENT_IDENTIFIER_MUNIT_BEFORE_TEST.equals(componentIdentifier)) {
      final MUnitDeclarationsAnnotation mUnitDeclarationsAnnotation =
          getMUnitDeclarationsAnnotation(annotatingMuleAstVisitorContext);
      mUnitDeclarationsAnnotation.setBeforeTestMuleFlowNode(muleFlowNode);
    } else if (COMPONENT_IDENTIFIER_MUNIT_AFTER_TEST.equals(componentIdentifier)) {
      final MUnitDeclarationsAnnotation mUnitDeclarationsAnnotation =
          getMUnitDeclarationsAnnotation(annotatingMuleAstVisitorContext);
      mUnitDeclarationsAnnotation.setAfterTestMuleFlowNode(muleFlowNode);
    } else if (COMPONENT_IDENTIFIER_MUNIT_BEFORE_SUITE.equals(componentIdentifier)) {
      final MUnitDeclarationsAnnotation mUnitDeclarationsAnnotation =
          getMUnitDeclarationsAnnotation(annotatingMuleAstVisitorContext);
      mUnitDeclarationsAnnotation.setBeforeSuiteMuleFlowNode(muleFlowNode);
    } else if (COMPONENT_IDENTIFIER_MUNIT_AFTER_SUITE.equals(componentIdentifier)) {
      final MUnitDeclarationsAnnotation mUnitDeclarationsAnnotation =
          getMUnitDeclarationsAnnotation(annotatingMuleAstVisitorContext);
      mUnitDeclarationsAnnotation.setAfterSuiteMuleFlowNode(muleFlowNode);
    }
  }

  private MUnitDeclarationsAnnotation getMUnitDeclarationsAnnotation(
                                                                     AnnotatingMuleAstVisitorContext visitorContext) {
    final MuleApplicationNode muleApplicationNode = visitorContext.getAnnotation(MuleApplicationAnnotation.class)
        .map(MuleApplicationAnnotation::getMuleApplicationNode)
        .orElseThrow(() -> new IllegalArgumentException("Mule application node not set."));
    return muleApplicationNode.getOrCreateAnnotation(MUnitDeclarationsAnnotation.class, MUnitDeclarationsAnnotation::new);
  }
}
