package org.mule.datasense.impl.phases.builder;

import org.mule.datasense.impl.util.ComponentIdentifierUtils;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.config.internal.model.ComponentModel;

import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

;import static org.mule.datasense.impl.DefaultDataSense.COMPONENT_IDENTIFIER_FLOW;
import static org.mule.datasense.impl.DefaultDataSense.COMPONENT_IDENTIFIER_MULE;
import static org.mule.datasense.impl.DefaultDataSense.COMPONENT_IDENTIFIER_MUNIT_AFTER_SUITE;
import static org.mule.datasense.impl.DefaultDataSense.COMPONENT_IDENTIFIER_MUNIT_AFTER_TEST;
import static org.mule.datasense.impl.DefaultDataSense.COMPONENT_IDENTIFIER_MUNIT_BEFORE_SUITE;
import static org.mule.datasense.impl.DefaultDataSense.COMPONENT_IDENTIFIER_MUNIT_BEFORE_TEST;
import static org.mule.datasense.impl.DefaultDataSense.COMPONENT_IDENTIFIER_MUNIT_TEST;
import static org.mule.datasense.impl.DefaultDataSense.COMPONENT_IDENTIFIER_SUBFLOW;

public class MuleAstParser {

  public static final String MULE_CORE = "http://www.mulesoft.org/schema/mule/core";
  public static final String MULE_EE_CORE = "http://www.mulesoft.org/schema/mule/ee/core";
  public static final String MULE_EE_BATCH = "http://www.mulesoft.org/schema/mule/batch";
  public static final String MULE_MUNIT = "http://www.mulesoft.org/schema/mule/munit";

  private static Set<ComponentIdentifier> FLOW_COMPONENT_IDENTIFIERS =
    Stream.of(
        COMPONENT_IDENTIFIER_FLOW,
        COMPONENT_IDENTIFIER_SUBFLOW,
        COMPONENT_IDENTIFIER_MUNIT_TEST,
        COMPONENT_IDENTIFIER_MUNIT_BEFORE_TEST,
        COMPONENT_IDENTIFIER_MUNIT_AFTER_TEST,
        COMPONENT_IDENTIFIER_MUNIT_BEFORE_SUITE,
        COMPONENT_IDENTIFIER_MUNIT_AFTER_SUITE
        ).collect(Collectors.toSet());

  public Optional<AstNodeBuilder> parse(ComponentModel componentModel, MuleAstParserContext muleAstParserContext) {
    muleAstParserContext.enter(componentModel);
    Optional<AstNodeBuilder> result = Optional.empty();
    ComponentIdentifier componentIdentifier = ComponentIdentifierUtils.createFromComponentModel(componentModel);
    if (componentIdentifier.equals(COMPONENT_IDENTIFIER_MULE)) {
      MuleApplicationNodeBuilder muleApplicationNodeBuilder =
          new MuleApplicationNodeBuilder(componentIdentifier);
      muleApplicationNodeBuilder.name("app");
      componentModel.getInnerComponents()
          .stream()
          .map(innerComponentModel -> parse(innerComponentModel, muleAstParserContext))
          .filter(Optional::isPresent)
          .map(Optional::get)
          .filter(astNodeBuilder -> astNodeBuilder instanceof MuleFlowNodeBuilder)
          .map(astNodeBuilder -> (MuleFlowNodeBuilder) astNodeBuilder)
          .forEach(muleApplicationNodeBuilder::muleFlow);
      result = Optional.of(muleApplicationNodeBuilder);
    } else if (FLOW_COMPONENT_IDENTIFIERS.contains(componentIdentifier)) {
      MuleFlowNodeBuilder muleFlowNodeBuilder =
          new MuleFlowNodeBuilder(ComponentIdentifierUtils.createFromComponentModel(componentModel));
      muleFlowNodeBuilder.config(componentModel);
      boolean traverse = muleAstParserContext.getDataSenseResolutionScopeStrategy()
          .map(dataSenseResolutionScopeStrategy -> dataSenseResolutionScopeStrategy.match(componentModel)).orElse(true);
      if (traverse) {
        getAstNodeBuilder(componentModel, muleAstParserContext, componentIdentifier).ifPresent(astNodeBuilder -> {
          if (astNodeBuilder instanceof MessageProcessorNodeBuilder) {
            final MessageProcessorNodeBuilder messageProcessorNodeBuilder = (MessageProcessorNodeBuilder) astNodeBuilder;
            muleFlowNodeBuilder.messageProcessor(messageProcessorNodeBuilder);
          }
        });
/*
        MessageProcessorNodeBuilder messageProcessorNodeBuilder = new MessageProcessorNodeBuilder(componentIdentifier);
        messageProcessorNodeBuilder.config(componentModel);
        componentModel.getInnerComponents()
            .stream()
            .map(innerComponentModel -> parse(innerComponentModel, muleAstParserContext))
            .filter(Optional::isPresent)
            .map(Optional::get)
            .filter(astNodeBuilder -> astNodeBuilder instanceof MessageProcessorNodeBuilder)
            .map(astNodeBuilder -> (MessageProcessorNodeBuilder) astNodeBuilder)
            .forEach(messageProcessorNodeBuilder::messageProcessor);
        muleFlowNodeBuilder.messageProcessor(messageProcessorNodeBuilder);
*/
      }
      result = Optional.of(muleFlowNodeBuilder);
    } else {
      result = getAstNodeBuilder(componentModel, muleAstParserContext, componentIdentifier);
    }

    if (!result.isPresent()) {
      muleAstParserContext.astlogger().debug("Ignoring unknown element " + componentIdentifier);
    }

    muleAstParserContext.exit(componentModel);
    return result;
  }

  private Optional<AstNodeBuilder> getAstNodeBuilder(ComponentModel componentModel, MuleAstParserContext muleAstParserContext,
                                                     ComponentIdentifier componentIdentifier) {
    Optional<AstNodeBuilder> result;
    result = muleAstParserContext.getComponentModelType(componentModel).map(componentModelType -> {

      final Stream<MessageProcessorNodeBuilder> messageProcessorNodeBuilders = componentModel.getInnerComponents()
          .stream()
          .map(innerComponentModel -> parse(innerComponentModel, muleAstParserContext))
          .filter(Optional::isPresent)
          .map(Optional::get)
          .filter(astNodeBuilder -> astNodeBuilder instanceof MessageProcessorNodeBuilder)
          .map(astNodeBuilder -> (MessageProcessorNodeBuilder) astNodeBuilder);

      final MuleAstParseProvider parseProvider = muleAstParserContext.getParseProvider(componentModel).orElse(null);
      if (parseProvider != null) {
        return parseProvider.parse(componentIdentifier, componentModel, componentModelType,
                                   messageProcessorNodeBuilders.collect(Collectors.toList()), muleAstParserContext)
            .orElse(null);
      } else {
        MessageProcessorNodeBuilder messageProcessorNodeBuilder = new MessageProcessorNodeBuilder(componentIdentifier);
        messageProcessorNodeBuilder.config(componentModel);
        messageProcessorNodeBuilder.componentModelType(componentModelType);
        messageProcessorNodeBuilders
            .forEach(messageProcessorNodeBuilder::messageProcessor);
        return messageProcessorNodeBuilder;
      }
    });
    return result;
  }

}
