package org.mule.datasense.impl.phases.builder;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import org.mule.datasense.api.metadataprovider.ApplicationModel;
import org.mule.datasense.api.metadataprovider.DataSenseProvider;
import org.mule.datasense.impl.DefaultDataSense;
import org.mule.datasense.impl.util.ComponentIdentifierUtils;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.config.internal.model.ComponentModel;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.Optional;

import static java.util.Optional.ofNullable;

public class SimpleDependenciesResolutionScopeStrategy extends DependenciesResolutionScopeStrategy {

  private ArrayList included;

  public SimpleDependenciesResolutionScopeStrategy(ApplicationModel applicationModel,
                                                   DataSenseProvider dataSenseProvider,
                                                   DataSenseResolutionScopeStrategy dataSenseResolutionScopeStrategy) {
    super(applicationModel, dataSenseProvider, dataSenseResolutionScopeStrategy);
    included = new ArrayList();
    init();
  }

  private void init() {
    final org.mule.runtime.config.internal.model.ApplicationModel muleApplicationModel =
        getApplicationModel().getMuleApplicationModel();

    Multimap<String, String> flowDependenciesByFlow = ArrayListMultimap.create();
    muleApplicationModel.executeOnEveryFlow(componentModel -> {
      final String flowName = componentModel.getNameAttribute();
      if (flowName != null) {
        componentModel.executedOnEveryInnerComponent(childComponentModel -> {
          final ComponentIdentifier componentIdentifier =
              ComponentIdentifierUtils.createFromComponentModel(childComponentModel);
          if (DefaultDataSense.COMPONENT_IDENTIFIER_FLOW_REF.equals(componentIdentifier)) {
            ofNullable(childComponentModel.getNameAttribute()).ifPresent(flowRefName -> {
              flowDependenciesByFlow.put(flowName, flowRefName);
            });
          }
        });
      }
    });

    Deque<String> deque = new ArrayDeque<>();

    // prefill queue with accepted flows
    muleApplicationModel.executeOnEveryFlow(componentModel -> {
      if (getDataSenseResolutionScopeStrategy().match(componentModel)) {
        ofNullable(componentModel.getNameAttribute()).ifPresent(deque::add);
      }
    });

    included.clear();
    while (!deque.isEmpty()) {
      final String flow = deque.pop();
      if (!included.contains(flow)) {
        included.add(flow);
        final Collection<String> flowDependencies = flowDependenciesByFlow.get(flow);
        flowDependencies.forEach(deque::offer);
      }
    }
  }

  @Override
  public boolean match(ComponentModel componentModel) {
    return super.match(componentModel) || visited(componentModel);
  }

  private boolean visited(ComponentModel componentModel) {
    return included.contains(componentModel.getNameAttribute());
  }
}
