package org.mule.datasense.impl.phases.scoping;

import org.mule.datasense.impl.model.ast.AstNotification;
import org.mule.datasense.impl.model.ast.BaseAstNodeVisitorContext;
import org.mule.datasense.impl.model.types.EventType;
import org.mule.datasense.impl.phases.typing.TypingEnvironment;
import org.mule.datasense.impl.phases.typing.resolver.TypeResolverRegistry;

public class IncomingAstVisitorContext extends BaseAstNodeVisitorContext {

  private EventType incomingEventType;

  public IncomingAstVisitorContext(TypeResolverRegistry typeResolverRegistry, AstNotification astNotification) {
    super(typeResolverRegistry, astNotification);
  }


  public void setIncomingEventType(EventType incomingEventType) {
    this.incomingEventType = incomingEventType;
  }

  public EventType getIncomingEventType() {
    return incomingEventType;
  }
}
