package org.mule.datasense.impl.phases.typing.resolver;

import org.mule.datasense.impl.model.annotations.DefinesTypeAnnotation;
import org.mule.datasense.impl.model.annotations.UsesTypeAnnotation;
import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.model.types.EventType;
import org.mule.datasense.impl.model.types.TypeUtils;
import org.mule.datasense.impl.model.types.TypesHelper;
import org.mule.datasense.impl.phases.builder.ComponentModelType;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitor;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitorContext;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.message.api.MessageMetadataType;
import org.mule.metadata.message.api.MessageMetadataTypeBuilder;
import org.mule.runtime.api.component.location.LocationPart;
import org.mule.runtime.dsl.api.component.config.DefaultComponentLocation;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class ScatterGatherTypeResolver extends StructuralNodeTypeResolver {

  @Override
  protected EventType resolve(MessageProcessorNode messageProcessorNode, EventType inputEventType,
                              TypingMuleAstVisitor typingMuleAstVisitor,
                              TypingMuleAstVisitorContext typingMuleAstVisitorContext) {

    // @todo process collect-list
    final MessageMetadataTypeBuilder messageMetadataTypeBuilder = TypesHelper.getMessageMetadataTypeBuilder();
    final ObjectTypeBuilder objectTypeBuilder = messageMetadataTypeBuilder.payload().objectType();
    messageMetadataTypeBuilder.attributes().voidType();

    List<EventType> nestedEventTypes = new ArrayList<>();
    messageProcessorNode.getMessageProcessorNodes().forEach(pipedMessageProcessorNode -> {
      final EventType nestedEventType =
          typingMuleAstVisitor.resolveType(pipedMessageProcessorNode, inputEventType, typingMuleAstVisitorContext);
      nestedEventTypes.add(nestedEventType);
      final MessageMetadataTypeBuilder routeMessageMetadataTypeBuilder = TypesHelper.getMessageMetadataTypeBuilder();
      final MetadataType routePayloadMetadataType = TypeUtils.getMessageMetadataType(nestedEventType).flatMap(
                                                                                                              MessageMetadataType::getPayloadType)
          .orElse(TypesHelper.getTypeBuilder().anyType().build());
      TypeUtils.getMessageMetadataType(nestedEventType).flatMap(
                                                                MessageMetadataType::getAttributesType)
          .ifPresent(routeMessageMetadataTypeBuilder::attributes);
      routeMessageMetadataTypeBuilder.payload(routePayloadMetadataType);

      final DefaultComponentLocation defaultComponentLocation =
          pipedMessageProcessorNode.getComponentModel().getComponentLocation();
      final LocationPart[] parts =
          defaultComponentLocation.getParts().toArray(new LocationPart[defaultComponentLocation.getParts().size()]);
      String routeId = buildRouteId(parts);
      objectTypeBuilder.addField().required().key(routeId).value(routeMessageMetadataTypeBuilder.build());
    });

    EventType outputEventType = TypeUtils.merge(TypeUtils.union(nestedEventTypes),
                                                new EventType(TypeUtils.asVarDecls(messageMetadataTypeBuilder.build())));

    messageProcessorNode.annotate(new UsesTypeAnnotation(new EventType()));
    messageProcessorNode.annotate(new DefinesTypeAnnotation(outputEventType));

    return outputEventType;
  }

  private String buildRouteId(LocationPart[] parts) {
    return parts[parts.length - 1].getPartPath();
  }

  @Override
  public Optional<ComponentModelType> getComponentModelType() {
    return Optional.of(ComponentModelType.MESSAGE_PROCESSOR_NODE);
  }

  @Override
  protected boolean isSequential() {
    return false;
  }

  @Override
  protected boolean isPropagates(MessageProcessorNode messageProcessorNode) {
    return true;
  }

  @Override
  protected boolean isScope() {
    return true;
  }

}
