package org.mule.datasense.impl.phases.typing.resolver;


import org.mule.runtime.api.component.ComponentIdentifier;;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class TypeResolverRegistry {

  private final Map<ComponentIdentifier, TypeResolver> muleAstFunctionTypeResolverMap;

  public TypeResolverRegistry() {
    this.muleAstFunctionTypeResolverMap = new HashMap<>();
  }

  public void register(String componentIdentifier, TypeResolver typeResolver) {
    register(ComponentIdentifier.buildFromStringRepresentation(componentIdentifier), typeResolver);
  }

  public void register(ComponentIdentifier componentIdentifier, TypeResolver typeResolver) {
    muleAstFunctionTypeResolverMap.put(componentIdentifier, typeResolver);
  }

  public Optional<TypeResolver> get(ComponentIdentifier componentIdentifier) {
    if (componentIdentifier == null) {
      return Optional.empty();
    }
    return Optional.ofNullable(muleAstFunctionTypeResolverMap.get(componentIdentifier));
  }
}
