package org.mule.datasense.impl.phases.typing.resolver.transform;

import org.mule.datasense.impl.model.event.MuleEventExprBuilder;
import org.mule.datasense.impl.model.event.SimpleExprBuilder;
import org.mule.datasense.impl.model.event.ValueExprBuilder;
import org.mule.datasense.impl.util.ComponentIdentifierUtils;
import org.mule.runtime.config.internal.model.ComponentModel;import org.mule.runtime.api.component.ComponentIdentifier;;

import static java.util.Optional.ofNullable;
import static org.mule.datasense.impl.phases.builder.MuleAstParser.MULE_EE_CORE;

public class TransformParser {

  static final ComponentIdentifier MESSAGE = ComponentIdentifierUtils.createFromNamespaceAndName(MULE_EE_CORE, "message");
  static final ComponentIdentifier VARIABLES = ComponentIdentifierUtils.createFromNamespaceAndName(MULE_EE_CORE, "variables");
  static final ComponentIdentifier SET_PAYLOAD = ComponentIdentifierUtils.createFromNamespaceAndName(MULE_EE_CORE, "set-payload");
  static final ComponentIdentifier SET_ATTRIBUTES =
      ComponentIdentifierUtils.createFromNamespaceAndName(MULE_EE_CORE, "set-attributes");
  static final ComponentIdentifier SET_VARIABLE =
      ComponentIdentifierUtils.createFromNamespaceAndName(MULE_EE_CORE, "set-variable");
  static final String ATTR_VARIABLE_NAME = "variableName";

  public void parseMessage(ComponentModel componentModel, MuleEventExprBuilder muleEventExprBuilder) {
    componentModel.getInnerComponents().forEach(childComponentModel -> {
      ComponentIdentifier componentIdentifier = ComponentIdentifierUtils.createFromComponentModel(childComponentModel);
      if (SET_PAYLOAD.equals(componentIdentifier)) {
        ofNullable(childComponentModel.getTextContent()).ifPresent(expression -> {
          muleEventExprBuilder.message(m -> m.value(m1 -> m1.payload(new SimpleExprBuilder(expression))));
        });
      } else if (SET_ATTRIBUTES.equals(componentIdentifier)) {
        ofNullable(childComponentModel.getTextContent()).ifPresent(expression -> {
          muleEventExprBuilder.message(m -> m.value(m1 -> m1.attributes(new SimpleExprBuilder(expression))));
        });
      }
    });
  }

  public void parseVariables(ComponentModel componentModel, MuleEventExprBuilder muleEventExprBuilder) {
    componentModel.getInnerComponents().forEach(childComponentModel -> {
      ComponentIdentifier componentIdentifier = ComponentIdentifierUtils.createFromComponentModel(childComponentModel);
      if (SET_VARIABLE.equals(componentIdentifier)) {
        String name = childComponentModel.getParameters().get(ATTR_VARIABLE_NAME);
        String expression = childComponentModel.getTextContent();
        if (name != null && expression != null) {
          muleEventExprBuilder.variable(name, v -> v.value(new ValueExprBuilder(new SimpleExprBuilder(expression))));
        }
      }
    });
  }

  public MuleEventExprBuilder parse(ComponentModel transformComponentModel) {
    MuleEventExprBuilder muleEventExprBuilder = new MuleEventExprBuilder();
    transformComponentModel.getInnerComponents().forEach(componentModel -> {
      ComponentIdentifier componentIdentifier = ComponentIdentifierUtils.createFromComponentModel(componentModel);
      if (MESSAGE.equals(componentIdentifier)) {
        parseMessage(componentModel, muleEventExprBuilder);
      } else if (VARIABLES.equals(componentIdentifier)) {
        parseVariables(componentModel, muleEventExprBuilder);
      }
    });
    return muleEventExprBuilder;
  }
}
