/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.model.ast;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.mule.datasense.impl.model.ast.AstNodeVisitor;
import org.mule.datasense.impl.model.ast.BaseAstNode;
import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.model.ast.MuleFlowNode;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.component.location.Location;

public class MuleApplicationNode
extends BaseAstNode {
    private final List<MuleFlowNode> muleFlowNodes = new ArrayList<MuleFlowNode>();
    private final Map<String, MuleFlowNode> muleFlowNodeByNameMap = new HashMap<String, MuleFlowNode>();
    private Map<ComponentLocation, MessageProcessorNode> messageProcessorNodeMap = new HashMap<ComponentLocation, MessageProcessorNode>();

    public MuleApplicationNode(ComponentIdentifier componentIdentifier, Stream<MuleFlowNode> muleFlowNodes) {
        super(componentIdentifier);
        muleFlowNodes.forEach(this::add);
    }

    private void add(MuleFlowNode muleFlowNode) {
        this.muleFlowNodes.add(muleFlowNode);
        this.muleFlowNodeByNameMap.put(muleFlowNode.getName(), muleFlowNode);
    }

    public Stream<MuleFlowNode> getMuleFlowNodes() {
        return this.muleFlowNodes.stream();
    }

    @Override
    public <T> Object accept(AstNodeVisitor<T> astNodeVisitor, T context) {
        return astNodeVisitor.visit(this, context);
    }

    public void register(ComponentLocation componentLocation, MessageProcessorNode messageProcessorNode) {
        Preconditions.checkState((!this.messageProcessorNodeMap.containsKey(componentLocation) ? 1 : 0) != 0, (Object)String.format("Node already registered for componentLocation %s", componentLocation));
        this.messageProcessorNodeMap.put(componentLocation, messageProcessorNode);
    }

    public Optional<MessageProcessorNode> findMessageProcessorNode(String location) {
        return this.messageProcessorNodeMap.entrySet().stream().filter(messageProcessorNode -> ((ComponentLocation)messageProcessorNode.getKey()).getLocation().equals(location)).map(Map.Entry::getValue).findFirst();
    }

    public Optional<MessageProcessorNode> findMessageProcessorNode(Location location) {
        return this.findMessageProcessorNode(location.toString());
    }

    public Optional<MuleFlowNode> findMuleFlowNode(String flow) {
        if (flow == null) {
            return Optional.empty();
        }
        return this.getMuleFlowNodes().filter(muleFlowNode -> flow.equals(muleFlowNode.getName())).findFirst();
    }

    public Stream<MessageProcessorNode> findMessageProcessorNodes(boolean includeRoot) {
        return this.messageProcessorNodeMap.values().stream().filter(messageProcessorNode -> includeRoot || !messageProcessorNode.isRootMessageProcessorNode());
    }

    public Stream<MessageProcessorNode> findMessageProcessorNodes() {
        return this.findMessageProcessorNodes(false);
    }
}

