/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.model.reporting;

import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.runtime.api.i18n.I18nMessage;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.metadata.resolving.MetadataFailure;

public class NotificationMessages {
    public static final String MSG_REQUIRED_PARAMETER_MISSING = "Required parameter missing";
    public static final String MSG_UNASSIGNABLE = "Unassignable";
    public static final String MSG_FAILED_TO_OBTAIN_METADATA = "Failed to obtain dynamic metadata resolving request [%s].";
    public static final String MSG_FAILED_TO_RESOLVE_FLOWREF = "Failed to solve flow-ref. Flow '%s' not found.";
    private static final String MSG_FAILED_TO_INFER_FLOW_OUTPUT_RECURSIVE_CALL_DETECTED = "Failed to infer output type on flow '%s'. It is required to define output type on flows with recursive calls.";

    public static final I18nMessage MSG_FAILED_TO_ENRICH_KEYS(MetadataFailure metadataFailure) {
        String failingElement = metadataFailure.getFailingElement().orElse("");
        String failingComponent = metadataFailure.getFailingComponent().name();
        String failureCode = metadataFailure.getFailureCode().toString();
        String message = metadataFailure.getMessage();
        return I18nMessageFactory.createStaticMessage((String)"Failed to enrich keys. component: %s, element: %s, code: %s - Message: %s.", (Object[])new Object[]{failingComponent, failingElement, failureCode, message});
    }

    public static final I18nMessage REASON_FAILED_TO_ENRICH_KEYS(MetadataFailure metadataFailure) {
        String failingElement = metadataFailure.getFailingElement().orElse("");
        String failingComponent = metadataFailure.getFailingComponent().name();
        String failureCode = metadataFailure.getFailureCode().toString();
        String reason = metadataFailure.getReason();
        return I18nMessageFactory.createStaticMessage((String)"Failed to enrich keys. component: %s, element: %s, code: %s - Reason: %s.", (Object[])new Object[]{failingComponent, failingElement, failureCode, reason});
    }

    public static final I18nMessage MSG_FAILED_TO_RESOLVE_DYNAMIC_MODEL(MetadataFailure metadataFailure) {
        String failingElement = metadataFailure.getFailingElement().orElse("");
        String failingComponent = metadataFailure.getFailingComponent().name();
        String failureCode = metadataFailure.getFailureCode().toString();
        String message = metadataFailure.getMessage();
        return I18nMessageFactory.createStaticMessage((String)"Failed to resolve dynamic model. component: %s, element: %s, code: %s - Message: %s.", (Object[])new Object[]{failingComponent, failingElement, failureCode, message});
    }

    public static final I18nMessage REASON_FAILED_TO_RESOLVE_DYNAMIC_MODEL(MetadataFailure metadataFailure) {
        String failingElement = metadataFailure.getFailingElement().orElse("");
        String failingComponent = metadataFailure.getFailingComponent().name();
        String failureCode = metadataFailure.getFailureCode().toString();
        String reason = metadataFailure.getReason();
        return I18nMessageFactory.createStaticMessage((String)"Failed to resolve dynamic model. component: %s, element: %s, code: %s - Reason: %s.", (Object[])new Object[]{failingComponent, failingElement, failureCode, reason});
    }

    public static final I18nMessage MSG_SCRIPTING_LANGUAGE_ERROR(String expression, String reason) {
        return I18nMessageFactory.createStaticMessage((String)"Scripting language error on expression '%s'. Reason: %s.", (Object[])new Object[]{expression, reason});
    }

    public static final I18nMessage MSG_SCRIPTING_LANGUAGE_WARNING(String expression, String reason) {
        return I18nMessageFactory.createStaticMessage((String)"Scripting language warning on expression '%s'. Reason: %s.", (Object[])new Object[]{expression, reason});
    }

    public static final I18nMessage MSG_UNKNOWN_FLOW_COMPONENT(MessageProcessorNode messageProcessorNode) {
        return I18nMessageFactory.createStaticMessage((String)"Unknown message processor %s. Datasense will use passthrough semantics.", (Object[])new Object[]{messageProcessorNode.getIdentifier()});
    }

    public static final I18nMessage MSG_RAML_RESOLUTION_NOTIFICATION(String notificationType, String message) {
        return I18nMessageFactory.createStaticMessage((String)"Raml resolution %s: %s.", (Object[])new Object[]{notificationType, message});
    }

    public static final I18nMessage MSG_RAML_RESOLUTION_INITIALIZATION(String message) {
        return I18nMessageFactory.createStaticMessage((String)"Raml resolution initialization failed. Error: %s.", (Object[])new Object[]{message});
    }

    public static final I18nMessage MSG_RECURSIVE_CALL_DETECTED(String flow) {
        return I18nMessageFactory.createStaticMessage((String)MSG_FAILED_TO_INFER_FLOW_OUTPUT_RECURSIVE_CALL_DETECTED, (Object[])new Object[]{flow});
    }
}

