/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.phases.builder;

import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mule.datasense.impl.DefaultDataSense;
import org.mule.datasense.impl.phases.builder.AstNodeBuilder;
import org.mule.datasense.impl.phases.builder.ComponentModelType;
import org.mule.datasense.impl.phases.builder.MessageProcessorNodeBuilder;
import org.mule.datasense.impl.phases.builder.MuleApplicationNodeBuilder;
import org.mule.datasense.impl.phases.builder.MuleAstParseProvider;
import org.mule.datasense.impl.phases.builder.MuleAstParserContext;
import org.mule.datasense.impl.phases.builder.MuleFlowNodeBuilder;
import org.mule.datasense.impl.util.ComponentIdentifierUtils;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.config.internal.model.ComponentModel;

public class MuleAstParser {
    public static final String MULE_CORE = "http://www.mulesoft.org/schema/mule/core";
    public static final String MULE_EE_CORE = "http://www.mulesoft.org/schema/mule/ee/core";
    public static final String MULE_EE_BATCH = "http://www.mulesoft.org/schema/mule/batch";
    public static final String MULE_MUNIT = "http://www.mulesoft.org/schema/mule/munit";
    private static Set<ComponentIdentifier> FLOW_COMPONENT_IDENTIFIERS = Stream.of(DefaultDataSense.COMPONENT_IDENTIFIER_FLOW, DefaultDataSense.COMPONENT_IDENTIFIER_SUBFLOW, DefaultDataSense.COMPONENT_IDENTIFIER_MUNIT_TEST, DefaultDataSense.COMPONENT_IDENTIFIER_MUNIT_BEFORE_TEST, DefaultDataSense.COMPONENT_IDENTIFIER_MUNIT_AFTER_TEST, DefaultDataSense.COMPONENT_IDENTIFIER_MUNIT_BEFORE_SUITE, DefaultDataSense.COMPONENT_IDENTIFIER_MUNIT_AFTER_SUITE).collect(Collectors.toSet());

    public Optional<AstNodeBuilder> parse(ComponentModel componentModel, MuleAstParserContext muleAstParserContext) {
        muleAstParserContext.enter(componentModel);
        Optional<Object> result = Optional.empty();
        ComponentIdentifier componentIdentifier = ComponentIdentifierUtils.createFromComponentModel(componentModel);
        if (componentIdentifier.equals(DefaultDataSense.COMPONENT_IDENTIFIER_MULE)) {
            MuleApplicationNodeBuilder muleApplicationNodeBuilder = new MuleApplicationNodeBuilder(componentIdentifier);
            muleApplicationNodeBuilder.name("app");
            componentModel.getInnerComponents().stream().map(innerComponentModel -> this.parse((ComponentModel)innerComponentModel, muleAstParserContext)).filter(Optional::isPresent).map(Optional::get).filter(astNodeBuilder -> astNodeBuilder instanceof MuleFlowNodeBuilder).map(astNodeBuilder -> (MuleFlowNodeBuilder)astNodeBuilder).forEach(muleApplicationNodeBuilder::muleFlow);
            result = Optional.of(muleApplicationNodeBuilder);
        } else if (FLOW_COMPONENT_IDENTIFIERS.contains(componentIdentifier)) {
            MuleFlowNodeBuilder muleFlowNodeBuilder = new MuleFlowNodeBuilder(ComponentIdentifierUtils.createFromComponentModel(componentModel));
            muleFlowNodeBuilder.config(componentModel);
            boolean traverse = muleAstParserContext.getDataSenseResolutionScopeStrategy().map(dataSenseResolutionScopeStrategy -> dataSenseResolutionScopeStrategy.match(componentModel)).orElse(true);
            if (traverse) {
                this.getAstNodeBuilder(componentModel, muleAstParserContext, componentIdentifier).ifPresent(astNodeBuilder -> {
                    if (astNodeBuilder instanceof MessageProcessorNodeBuilder) {
                        MessageProcessorNodeBuilder messageProcessorNodeBuilder = (MessageProcessorNodeBuilder)astNodeBuilder;
                        muleFlowNodeBuilder.messageProcessor(messageProcessorNodeBuilder);
                    }
                });
            }
            result = Optional.of(muleFlowNodeBuilder);
        } else {
            result = this.getAstNodeBuilder(componentModel, muleAstParserContext, componentIdentifier);
        }
        if (!result.isPresent()) {
            muleAstParserContext.astlogger().debug("Ignoring unknown element " + componentIdentifier, new Object[0]);
        }
        muleAstParserContext.exit(componentModel);
        return result;
    }

    private Optional<AstNodeBuilder> getAstNodeBuilder(ComponentModel componentModel, MuleAstParserContext muleAstParserContext, ComponentIdentifier componentIdentifier) {
        Optional<AstNodeBuilder> result = muleAstParserContext.getComponentModelType(componentModel).map(componentModelType -> {
            Stream<MessageProcessorNodeBuilder> messageProcessorNodeBuilders = componentModel.getInnerComponents().stream().map(innerComponentModel -> this.parse((ComponentModel)innerComponentModel, muleAstParserContext)).filter(Optional::isPresent).map(Optional::get).filter(astNodeBuilder -> astNodeBuilder instanceof MessageProcessorNodeBuilder).map(astNodeBuilder -> (MessageProcessorNodeBuilder)astNodeBuilder);
            MuleAstParseProvider parseProvider = muleAstParserContext.getParseProvider(componentModel).orElse(null);
            if (parseProvider != null) {
                return parseProvider.parse(componentIdentifier, componentModel, (ComponentModelType)((Object)componentModelType), messageProcessorNodeBuilders.collect(Collectors.toList()), muleAstParserContext).orElse(null);
            }
            MessageProcessorNodeBuilder messageProcessorNodeBuilder = new MessageProcessorNodeBuilder(componentIdentifier);
            messageProcessorNodeBuilder.config(componentModel);
            messageProcessorNodeBuilder.componentModelType((ComponentModelType)((Object)componentModelType));
            messageProcessorNodeBuilders.forEach(messageProcessorNodeBuilder::messageProcessor);
            return messageProcessorNodeBuilder;
        });
        return result;
    }
}

