/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.phases.builder;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import org.mule.datasense.api.metadataprovider.ApplicationModel;
import org.mule.datasense.api.metadataprovider.DataSenseProvider;
import org.mule.datasense.impl.DefaultDataSense;
import org.mule.datasense.impl.phases.builder.DataSenseResolutionScopeStrategy;
import org.mule.datasense.impl.phases.builder.DependenciesResolutionScopeStrategy;
import org.mule.datasense.impl.util.ComponentIdentifierUtils;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.config.internal.model.ComponentModel;

public class SimpleDependenciesResolutionScopeStrategy
extends DependenciesResolutionScopeStrategy {
    private ArrayList included = new ArrayList();

    public SimpleDependenciesResolutionScopeStrategy(ApplicationModel applicationModel, DataSenseProvider dataSenseProvider, DataSenseResolutionScopeStrategy dataSenseResolutionScopeStrategy) {
        super(applicationModel, dataSenseProvider, dataSenseResolutionScopeStrategy);
        this.init();
    }

    private void init() {
        org.mule.runtime.config.internal.model.ApplicationModel muleApplicationModel = this.getApplicationModel().getMuleApplicationModel();
        ArrayListMultimap flowDependenciesByFlow = ArrayListMultimap.create();
        muleApplicationModel.executeOnEveryFlow(arg_0 -> SimpleDependenciesResolutionScopeStrategy.lambda$init$2((Multimap)flowDependenciesByFlow, arg_0));
        ArrayDeque deque = new ArrayDeque();
        muleApplicationModel.executeOnEveryFlow(componentModel -> {
            if (this.getDataSenseResolutionScopeStrategy().match((ComponentModel)componentModel)) {
                Optional.ofNullable(componentModel.getNameAttribute()).ifPresent(deque::add);
            }
        });
        this.included.clear();
        while (!deque.isEmpty()) {
            String flow = (String)deque.pop();
            if (this.included.contains(flow)) continue;
            this.included.add(flow);
            Collection flowDependencies = flowDependenciesByFlow.get((Object)flow);
            flowDependencies.forEach(deque::offer);
        }
    }

    @Override
    public boolean match(ComponentModel componentModel) {
        return super.match(componentModel) || this.visited(componentModel);
    }

    private boolean visited(ComponentModel componentModel) {
        return this.included.contains(componentModel.getNameAttribute());
    }

    private static /* synthetic */ void lambda$init$2(Multimap flowDependenciesByFlow, ComponentModel componentModel) {
        String flowName = componentModel.getNameAttribute();
        if (flowName != null) {
            componentModel.executedOnEveryInnerComponent(childComponentModel -> {
                ComponentIdentifier componentIdentifier = ComponentIdentifierUtils.createFromComponentModel(childComponentModel);
                if (DefaultDataSense.COMPONENT_IDENTIFIER_FLOW_REF.equals(componentIdentifier)) {
                    Optional.ofNullable(childComponentModel.getNameAttribute()).ifPresent(flowRefName -> flowDependenciesByFlow.put((Object)flowName, flowRefName));
                }
            });
        }
    }
}

