/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.phases.typing.resolver;

import java.util.Optional;
import org.mule.datasense.impl.model.annotations.DefinesTypeAnnotation;
import org.mule.datasense.impl.model.annotations.MuleApplicationAnnotation;
import org.mule.datasense.impl.model.annotations.UsesTypeAnnotation;
import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.model.ast.MuleApplicationNode;
import org.mule.datasense.impl.model.ast.MuleFlowNode;
import org.mule.datasense.impl.model.types.EventType;
import org.mule.datasense.impl.model.types.TypeUtils;
import org.mule.datasense.impl.phases.builder.ComponentModelType;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitor;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitorContext;
import org.mule.datasense.impl.phases.typing.resolver.SingleNodeTypeResolver;
import org.mule.datasense.impl.util.ExpressionLanguageUtils;
import org.mule.runtime.api.i18n.I18nMessageFactory;

public class FlowRefTypeResolver
extends SingleNodeTypeResolver {
    @Override
    public Optional<ComponentModelType> getComponentModelType() {
        return Optional.of(ComponentModelType.MESSAGE_PROCESSOR_NODE);
    }

    @Override
    protected EventType resolve(MessageProcessorNode messageProcessorNode, EventType inputEventType, TypingMuleAstVisitor typingMuleAstVisitor, TypingMuleAstVisitorContext visitorContext) {
        Optional usesTypeAnnotation = Optional.empty();
        Optional definesTypeAnnotation = Optional.empty();
        String referredFlowName = messageProcessorNode.getComponentModel().getNameAttribute();
        if (!ExpressionLanguageUtils.isExpression(referredFlowName)) {
            MuleApplicationNode muleApplicationNode = visitorContext.getAnnotation(MuleApplicationAnnotation.class).map(MuleApplicationAnnotation::getMuleApplicationNode).orElseThrow(() -> new IllegalArgumentException("Mule application node not set."));
            MuleFlowNode muleFlowNode = muleApplicationNode.findMuleFlowNode(referredFlowName).orElse(null);
            if (muleFlowNode != null) {
                usesTypeAnnotation = muleFlowNode.getAnnotation(UsesTypeAnnotation.class);
                definesTypeAnnotation = muleFlowNode.getAnnotation(DefinesTypeAnnotation.class);
                if (!definesTypeAnnotation.isPresent()) {
                    typingMuleAstVisitor.resolveType(muleFlowNode, TypeUtils.createEventType(null), visitorContext.getAstNotification(), muleApplicationNode);
                    definesTypeAnnotation = muleFlowNode.getAnnotation(DefinesTypeAnnotation.class);
                }
            } else {
                visitorContext.getAstNotification().reportError(messageProcessorNode.getAstNodeLocation(), I18nMessageFactory.createStaticMessage((String)"Failed to solve flow-ref. Flow '%s' not found.", (Object[])new Object[]{referredFlowName}));
            }
        }
        messageProcessorNode.annotate(usesTypeAnnotation.orElse(new UsesTypeAnnotation(new EventType())));
        messageProcessorNode.annotate(definesTypeAnnotation.orElse(new DefinesTypeAnnotation(new EventType())));
        return messageProcessorNode.getAnnotation(DefinesTypeAnnotation.class).map(DefinesTypeAnnotation::getDefinesEventType).orElse(new EventType());
    }

    @Override
    protected boolean isPropagates(MessageProcessorNode messageProcessorNode) {
        return true;
    }
}

