/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.phases.typing.resolver;

import com.google.common.base.Throwables;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.mule.datasense.impl.model.types.TypesHelper;
import org.mule.datasense.impl.util.LogSupport;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.model.MetadataType;

public class GlobalBindingMetadataTypes
implements LogSupport {
    public static final String GLOBAL_BINDING_MULE = "mule";
    public static final String GLOBAL_BINDING_SERVER = "server";
    public static final String GLOBAL_BINDING_APP = "app";
    public static final String GLOBAL_BINDING_CORRELATION_ID = "correlationId";
    public static final String GLOBAL_BINDING_DATA_TYPE = "dataType";
    public static final String GLOBAL_BINDING_AUTHENTICATION = "authentication";
    public static final String BINDING_ERROR = "error";
    private static final String BINDING_ERROR_CLASS = "org.mule.runtime.api.message.Error";
    private static final String GLOBAL_BINDING_DATA_TYPE_CLASS = "org.mule.runtime.api.metadata.DataType";
    private static final String GLOBAL_BINDING_AUTHENTICATION_CLASS = "org.mule.runtime.api.security.Authentication";

    private static MetadataType fallbackErrorType() {
        BaseTypeBuilder errorTypeBuilder = TypesHelper.getTypeBuilder();
        ObjectTypeBuilder typeBuilder = errorTypeBuilder.objectType();
        typeBuilder.addField().key("description").value().stringType();
        typeBuilder.addField().key("detailedDescription").value().stringType();
        ObjectTypeBuilder errorType = typeBuilder.addField().key("errorType").value().objectType();
        errorType.addField().key("identifier").value().stringType();
        errorType.addField().key("namespace").value().stringType();
        return errorTypeBuilder.build();
    }

    public static MetadataType errorType() {
        return TypesHelper.getTypeFromJavaClass(BINDING_ERROR_CLASS, GlobalBindingMetadataTypes.class.getClassLoader()).orElse(GlobalBindingMetadataTypes.fallbackErrorType());
    }

    public static MetadataType correlationIdType() {
        BaseTypeBuilder typeBuilder = TypesHelper.getTypeBuilder();
        typeBuilder.stringType();
        return typeBuilder.build();
    }

    public static MetadataType dataTypeType() {
        return GlobalBindingMetadataTypes.getTypeFromJavaClass(GLOBAL_BINDING_DATA_TYPE_CLASS);
    }

    public static MetadataType authenticationType() {
        return GlobalBindingMetadataTypes.getTypeFromJavaClass(GLOBAL_BINDING_AUTHENTICATION_CLASS);
    }

    public static MetadataType getTypeFromJavaClass(String clazz) {
        return TypesHelper.getTypeFromJavaClass(clazz, GlobalBindingMetadataTypes.class.getClassLoader()).orElseThrow(() -> new IllegalArgumentException(String.format("Failed to resolve class type %s", clazz)));
    }

    private static MetadataType metadataTypeFromWeaveResource(String resource, String type) {
        try {
            return TypesHelper.getTypeFromWeave(IOUtils.toString((InputStream)GlobalBindingMetadataTypes.class.getResourceAsStream(resource)), type).orElseThrow(() -> new IllegalArgumentException(String.format("Failed to resolve weave type %s", type)));
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static MetadataType appType() {
        return GlobalBindingMetadataTypes.metadataTypeFromWeaveResource("app-type.dw", "DataWeaveArtifactContext");
    }

    public static MetadataType serverType() {
        return GlobalBindingMetadataTypes.metadataTypeFromWeaveResource("server-type.dw", "ServerContext");
    }

    public static MetadataType muleType() {
        return GlobalBindingMetadataTypes.metadataTypeFromWeaveResource("mule-type.dw", "MuleInstanceContext");
    }
}

