/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl.phases.typing.resolver.transform;

import java.util.Optional;
import org.mule.datasense.impl.model.event.MuleEventExprBuilder;
import org.mule.datasense.impl.model.event.SimpleExprBuilder;
import org.mule.datasense.impl.model.event.ValueExprBuilder;
import org.mule.datasense.impl.util.ComponentIdentifierUtils;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.config.internal.model.ComponentModel;

public class TransformParser {
    static final ComponentIdentifier MESSAGE = ComponentIdentifierUtils.createFromNamespaceAndName("http://www.mulesoft.org/schema/mule/ee/core", "message");
    static final ComponentIdentifier VARIABLES = ComponentIdentifierUtils.createFromNamespaceAndName("http://www.mulesoft.org/schema/mule/ee/core", "variables");
    static final ComponentIdentifier SET_PAYLOAD = ComponentIdentifierUtils.createFromNamespaceAndName("http://www.mulesoft.org/schema/mule/ee/core", "set-payload");
    static final ComponentIdentifier SET_ATTRIBUTES = ComponentIdentifierUtils.createFromNamespaceAndName("http://www.mulesoft.org/schema/mule/ee/core", "set-attributes");
    static final ComponentIdentifier SET_VARIABLE = ComponentIdentifierUtils.createFromNamespaceAndName("http://www.mulesoft.org/schema/mule/ee/core", "set-variable");
    static final String ATTR_VARIABLE_NAME = "variableName";

    public void parseMessage(ComponentModel componentModel, MuleEventExprBuilder muleEventExprBuilder) {
        componentModel.getInnerComponents().forEach(childComponentModel -> {
            ComponentIdentifier componentIdentifier = ComponentIdentifierUtils.createFromComponentModel(childComponentModel);
            if (SET_PAYLOAD.equals(componentIdentifier)) {
                Optional.ofNullable(childComponentModel.getTextContent()).ifPresent(expression -> muleEventExprBuilder.message(m -> m.value(m1 -> m1.payload(new SimpleExprBuilder((String)expression)))));
            } else if (SET_ATTRIBUTES.equals(componentIdentifier)) {
                Optional.ofNullable(childComponentModel.getTextContent()).ifPresent(expression -> muleEventExprBuilder.message(m -> m.value(m1 -> m1.attributes(new SimpleExprBuilder((String)expression)))));
            }
        });
    }

    public void parseVariables(ComponentModel componentModel, MuleEventExprBuilder muleEventExprBuilder) {
        componentModel.getInnerComponents().forEach(childComponentModel -> {
            ComponentIdentifier componentIdentifier = ComponentIdentifierUtils.createFromComponentModel(childComponentModel);
            if (SET_VARIABLE.equals(componentIdentifier)) {
                String name = (String)childComponentModel.getParameters().get(ATTR_VARIABLE_NAME);
                String expression = childComponentModel.getTextContent();
                if (name != null && expression != null) {
                    muleEventExprBuilder.variable(name, v -> v.value(new ValueExprBuilder(new SimpleExprBuilder(expression))));
                }
            }
        });
    }

    public MuleEventExprBuilder parse(ComponentModel transformComponentModel) {
        MuleEventExprBuilder muleEventExprBuilder = new MuleEventExprBuilder();
        transformComponentModel.getInnerComponents().forEach(componentModel -> {
            ComponentIdentifier componentIdentifier = ComponentIdentifierUtils.createFromComponentModel(componentModel);
            if (MESSAGE.equals(componentIdentifier)) {
                this.parseMessage((ComponentModel)componentModel, muleEventExprBuilder);
            } else if (VARIABLES.equals(componentIdentifier)) {
                this.parseVariables((ComponentModel)componentModel, muleEventExprBuilder);
            }
        });
        return muleEventExprBuilder;
    }
}

