package org.mule.datasense.impl.model.event;

import com.google.common.base.Preconditions;
import org.mule.datasense.impl.phases.typing.resolver.ResolveTypeContext;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.message.api.MuleEventMetadataType;
import org.mule.metadata.message.api.MuleEventMetadataTypeBuilder;

public class LiteralTypeExpr implements Expr {

  private final MetadataType metadataType;

  public LiteralTypeExpr(MetadataType metadataType) {
    this.metadataType = metadataType;
    Preconditions.checkNotNull(metadataType);
  }

  @Override
  public MetadataType resolveType(MuleEventMetadataType muleEventMetadataType,
                                  ResolveTypeContext resolveTypeContext) {
    return metadataType;
  }

  @Override
  public void resolveInputType(MetadataType metadataType, MuleEventMetadataTypeBuilder muleEventMetadataTypeBuilder,
                               ResolveTypeContext resolveTypeContext) {}

}
