package org.mule.datasense.impl.model.event;

import org.mule.datasense.impl.model.types.TypeUtils;
import org.mule.datasense.impl.phases.typing.resolver.ResolveTypeContext;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.message.api.MuleEventMetadataType;
import org.mule.metadata.message.api.MuleEventMetadataTypeBuilder;

import com.google.common.base.Preconditions;

public class SimpleExpr implements Expr {

  private final String expression;

  public SimpleExpr(String expression) {
    Preconditions.checkNotNull(expression);
    this.expression = expression;
  }

  @Override
  public MetadataType resolveType(MuleEventMetadataType muleEventMetadataType,
                                  ResolveTypeContext resolveTypeContext) {
    return resolveTypeContext
        .getExpressionLanguageMetadataTypeResolver().getOutputType(
                                                                   TypeUtils.buildTypeBindings(muleEventMetadataType,
                                                                                               resolveTypeContext
                                                                                                   .getTypeBindings()),
                                                                   expression,
                                                                   resolveTypeContext.getMessageCallback());
  }

  @Override
  public void resolveInputType(MetadataType metadataType, MuleEventMetadataTypeBuilder muleEventMetadataTypeBuilder,
                               ResolveTypeContext resolveTypeContext) {
    resolveTypeContext.getExpressionLanguageMetadataTypeResolver()
        .getInputType(expression, metadataType, muleEventMetadataTypeBuilder, resolveTypeContext.getMessageCallback());
  }

}
