package org.mule.datasense.impl.phases.annotators;

import org.mule.datasense.impl.DefaultDataSense;
import org.mule.datasense.impl.model.annotations.TypeResolverAnnotation;
import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.phases.typing.AnnotatingMuleAstVisitorContext;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.construct.ConstructModel;
import org.mule.runtime.config.api.dsl.model.DslElementModel;

import java.util.Optional;

public class ConstructAnnotator extends BaseAnnotator {

  @Override
  public void annotate(MessageProcessorNode messageProcessorNode,
                       AnnotatingMuleAstVisitorContext annotatingMuleAstVisitorContext) {
    if (!messageProcessorNode.isRootMessageProcessorNode()) {
      if (!messageProcessorNode.getAnnotation(TypeResolverAnnotation.class).isPresent()) {
        final Optional<DslElementModel<ComponentModel>> objectDslElementModel =
            annotatingMuleAstVisitorContext.getDataSenseProviderResolver().getDslElementModelFactory()
                .create(messageProcessorNode.getComponentModel().getConfiguration());
        objectDslElementModel.ifPresent(operationModelDslElementModel -> {
          final ComponentModel componentModel = operationModelDslElementModel.getModel();
          if (componentModel instanceof ConstructModel) {
            messageProcessorNode.annotate(new TypeResolverAnnotation(DefaultDataSense.COMPONENT_IDENTIFIER_CONTAINER));
          }
        });
      }
    }
  }
}
