package org.mule.datasense.impl.phases.annotators;

import org.mule.datasense.declarations.model.ExtensionOperationTypeDeclaration;
import org.mule.datasense.impl.model.annotations.OperationCallBuilderAnnotation;
import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.datasense.impl.model.operation.OperationCallBuilder;
import org.mule.datasense.impl.phases.typing.AnnotatingMuleAstVisitorContext;
import org.mule.metadata.api.model.FunctionType;
import org.mule.metadata.api.model.MetadataType;

import java.util.Optional;
import java.util.function.Consumer;

public class OperationCallCustomizerAnnotator extends BaseOperationCallBuilderAnnotator {

  @Override
  public void annotate(MessageProcessorNode messageProcessorNode,
                       AnnotatingMuleAstVisitorContext annotatingMuleAstVisitorContext) {
    messageProcessorNode.getAnnotation(OperationCallBuilderAnnotation.class).ifPresent(operationCallBuilderAnnotation -> {
      final OperationCallBuilder operationCallBuilder = operationCallBuilderAnnotation.getOperationCallBuilder();
      annotatingMuleAstVisitorContext.getDataSenseProviderResolver()
          .findExtensionOperationTypeDeclaration(messageProcessorNode.getComponentModel())
          .ifPresent(extensionOperationTypeDeclaration -> {
            final FunctionType functionType = extensionOperationTypeDeclaration.getFunctionType();
            extensionOperationTypeDeclaration.getFunctionType().getParameters().forEach(functionParameter -> {
              operationCallBuilder.input(functionParameter.getName(), inputMappingBuilder -> {
                inputMappingBuilder.parameter(inputParameterBuilder -> {
                  inputParameterBuilder
                      .name(functionParameter.getName())
                      .type(functionParameter.getType());
                });
              });
            });
            functionType.getReturnType().ifPresent(operationCallBuilder::returnType);
          });

    });
  }
}
