package org.mule.datasense.impl.phases.typing.resolver;

import com.google.common.base.Throwables;
import org.apache.commons.io.IOUtils;
import org.mule.datasense.impl.model.types.TypesHelper;
import org.mule.datasense.impl.util.LogSupport;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.model.MetadataType;

import java.io.IOException;

import static java.lang.String.format;
import static org.mule.datasense.impl.model.types.TypesHelper.getTypeBuilder;
import static org.mule.datasense.impl.model.types.TypesHelper.getTypeFromWeave;

public class GlobalBindingMetadataTypes implements LogSupport {

  public static final String GLOBAL_BINDING_MULE = "mule";
  public static final String GLOBAL_BINDING_SERVER = "server";
  public static final String GLOBAL_BINDING_APP = "app";
  public static final String GLOBAL_BINDING_CORRELATION_ID = "correlationId";
  public static final String GLOBAL_BINDING_DATA_TYPE = "dataType";
  public static final String GLOBAL_BINDING_AUTHENTICATION = "authentication";

  private static final String GLOBAL_BINDING_DATA_TYPE_CLASS = "org.mule.runtime.api.metadata.DataType";
  private static final String GLOBAL_BINDING_AUTHENTICATION_CLASS = "org.mule.runtime.api.security.Authentication";

  public static MetadataType correlationIdType() {
    final BaseTypeBuilder typeBuilder = getTypeBuilder();
    typeBuilder.stringType();
    return typeBuilder.build();
  }

  public static MetadataType dataTypeType() {
    return getTypeFromJavaClass(GLOBAL_BINDING_DATA_TYPE_CLASS);
  }

  public static MetadataType authenticationType() {
    return getTypeFromJavaClass(GLOBAL_BINDING_AUTHENTICATION_CLASS);
  }

  public static MetadataType getTypeFromJavaClass(String clazz) {
    return TypesHelper.getTypeFromJavaClass(clazz, GlobalBindingMetadataTypes.class.getClassLoader())
        .orElseThrow(() -> new IllegalArgumentException(format("Failed to resolve class type %s", clazz)));
  }

  private static MetadataType metadataTypeFromWeaveResource(String resource, String type) {
    try {
      return getTypeFromWeave(IOUtils.toString(GlobalBindingMetadataTypes.class.getResourceAsStream(resource)), type)
          .orElseThrow(() -> new IllegalArgumentException(
                                                          format("Failed to resolve weave type %s", type)));
    } catch (IOException e) {
      throw Throwables.propagate(e);
    }
  }

  public static MetadataType appType() {
    return metadataTypeFromWeaveResource("app-type.dw", "DataWeaveArtifactContext");
  }

  public static MetadataType serverType() {
    return metadataTypeFromWeaveResource("server-type.dw", "ServerContext");
  }

  public static MetadataType muleType() {
    return metadataTypeFromWeaveResource("mule-type.dw", "MuleInstanceContext");
  }


}
