package org.mule.datasense.impl.phases.typing.resolver;

import org.mule.metadata.message.api.el.ExpressionLanguageMetadataTypeResolver;

import com.google.common.base.Preconditions;
import org.mule.metadata.message.api.el.TypeBindings;

public class ResolveTypeContext {

  private final ExpressionLanguageMetadataTypeResolver expressionLanguageMetadataTypeResolver;
  private ExpressionLanguageMetadataTypeResolver.MessageCallback messageCallback;
  private TypeBindings typeBindings;

  public ResolveTypeContext(
                            ExpressionLanguageMetadataTypeResolver expressionLanguageMetadataTypeResolver,
                            ExpressionLanguageMetadataTypeResolver.MessageCallback messageCallback, TypeBindings typeBindings) {
    this.typeBindings = typeBindings;
    Preconditions.checkNotNull(expressionLanguageMetadataTypeResolver);
    Preconditions.checkNotNull(messageCallback);
    this.expressionLanguageMetadataTypeResolver = expressionLanguageMetadataTypeResolver;
    this.messageCallback = messageCallback;
  }

  public ExpressionLanguageMetadataTypeResolver getExpressionLanguageMetadataTypeResolver() {
    return expressionLanguageMetadataTypeResolver;
  }

  public ExpressionLanguageMetadataTypeResolver.MessageCallback getMessageCallback() {
    return messageCallback;
  }

  public TypeBindings getTypeBindings() {
    return typeBindings;
  }
}
