package org.mule.datasense.impl.phases.typing.resolver;

import org.mule.datasense.impl.model.types.EventType;
import org.mule.datasense.impl.model.types.TypeUtils;
import org.mule.datasense.impl.model.types.VarDecl;
import org.mule.datasense.impl.phases.typing.TypingMuleAstVisitorContext;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.message.api.MuleEventMetadataType;
import org.mule.metadata.message.api.el.ExpressionLanguageMetadataTypeResolver;

import java.util.stream.Stream;

import static org.mule.datasense.impl.model.types.TypeUtils.asMessageMetadataTypeOrEmptyMessage;
import static org.mule.datasense.impl.model.types.TypeUtils.merge;
import static org.mule.datasense.impl.util.ExpressionLanguageUtils.extractExpression;
import static org.mule.datasense.impl.util.ExpressionLanguageUtils.resolveExpressionType;

public class TargetProcessingSupport {

  private MetadataType resolveTargetMetadataType(MuleEventMetadataType muleEventMetadataType, String targetValue,
                                                 TypingMuleAstVisitorContext visitorContext,
                                                 ExpressionLanguageMetadataTypeResolver.MessageCallback messageCallback) {
    final ExpressionLanguageMetadataTypeResolver expressionLanguageMetadataTypeResolver =
        visitorContext.getExpressionLanguageMetadataTypeResolver();

    return extractExpression(targetValue).map(targetValueExpression -> {
      return resolveExpressionType(targetValueExpression,
                                   muleEventMetadataType,
                                   visitorContext.getTypeBindings(),
                                   expressionLanguageMetadataTypeResolver, messageCallback);
    }).orElse(asMessageMetadataTypeOrEmptyMessage(muleEventMetadataType.getMessageType()));
  }

  private EventType resolveTargetEventType(String target, String targetValue, MuleEventMetadataType muleEventMetadataType,
                                           TypingMuleAstVisitorContext visitorContext,
                                           ExpressionLanguageMetadataTypeResolver.MessageCallback messageCallback) {
    MetadataType targetMetadataType =
        resolveTargetMetadataType(muleEventMetadataType, targetValue, visitorContext, messageCallback);
    return new EventType(Stream.of(new VarDecl(target, targetMetadataType)));
  }

  private EventType resolveVariablesEventType(MuleEventMetadataType muleEventMetadataType) {
    return new EventType(muleEventMetadataType.getVariables().getFields().stream().map(
                                                                                       objectFieldType -> new VarDecl(objectFieldType
                                                                                           .getKey().getName()
                                                                                           .getLocalPart(), objectFieldType
                                                                                               .getValue())));
  }

  public EventType processTarget(String target, String targetValue, MuleEventMetadataType muleEventMetadataType,
                                 TypingMuleAstVisitorContext visitorContext,
                                 ExpressionLanguageMetadataTypeResolver.MessageCallback messageCallback) {
    if (target == null) {
      return TypeUtils.asEventType(muleEventMetadataType);
    }
    return merge(resolveVariablesEventType(muleEventMetadataType),
                 resolveTargetEventType(target, targetValue, muleEventMetadataType, visitorContext, messageCallback));
  }


  public EventType processTarget(String target, String targetValue, EventType eventType,
                                 TypingMuleAstVisitorContext visitorContext,
                                 ExpressionLanguageMetadataTypeResolver.MessageCallback messageCallback) {
    MuleEventMetadataType muleEventMetadataType = TypeUtils.asMuleEventMetadataType(eventType).build();
    return processTarget(target, targetValue, muleEventMetadataType, visitorContext, messageCallback);
  }

}
