package org.mule.datasense.impl.phases.typing.resolver.errorhandling;

import org.mule.runtime.api.meta.model.error.ErrorModel;

import java.util.LinkedHashSet;
import java.util.Set;

public class ErrorHandlingContext {

  private final String id;
  private final Set<ErrorModel> unhandledErrors;
  private boolean open;

  public ErrorHandlingContext(String id) {
    this.id = id;
    unhandledErrors = new LinkedHashSet<>();
    open = true;
  }

  public Set<ErrorModel> getUnhandledErrors() {
    return unhandledErrors;
  }

  public void union(Set<ErrorModel> errorModels) {
    unhandledErrors.addAll(errorModels);
  }

  public void handle(ErrorMatcher errorMatcher) {
    unhandledErrors.removeIf(errorMatcher::matches);
  }

  public void close() {
    this.open = false;
  }

  public boolean isOpen() {
    return open;
  }
}
