package org.mule.datasense.impl.phases.typing.resolver.errorhandling;

import org.mule.runtime.api.meta.model.error.ErrorModel;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Set;

public class ErrorHandlingEnvironment {

  private Deque<ErrorHandlingContext> errorHandlingContexts;

  public ErrorHandlingEnvironment() {
    errorHandlingContexts = new ArrayDeque<>();
  }

  public void pushContext(String id) {
    errorHandlingContexts.push(new ErrorHandlingContext(id));
  }

  public void popContext() {
    final ErrorHandlingContext errorHandlingContext = errorHandlingContexts.pop();
    if (!errorHandlingContexts.isEmpty()) {
      throwErrors(errorHandlingContext.getUnhandledErrors());
    }
  }

  public ErrorHandlingContext getContext() {
    return errorHandlingContexts.peek();
  }

  public void enterErrorHandling() {
    getContext().close();
  }

  private ErrorHandlingContext findOpenContext() {
    for (ErrorHandlingContext errorHandlingContext : errorHandlingContexts) {
      if (errorHandlingContext.isOpen()) {
        return errorHandlingContext;
      }
    }
    throw new IllegalStateException();
  }

  public void throwErrors(Set<ErrorModel> errorModels) {
    findOpenContext().union(errorModels);
  }

  public void handleErrors(ErrorMatcher errorMatcher) {
    getContext().handle(errorMatcher);
  }

}
